from dataclasses import dataclass
from typing import Optional

from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.function_tool_call import FunctionToolCall
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.memory_fragment import MemoryFragment
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_validation_request import ToolValidationRequest
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_validation_response import ToolValidationResponse

@dataclass
class ToolCallWithPotentialValidation:
    dku_tool_call: FunctionToolCall
    id: str
    name: str
    arguments: dict
    tool_validation_responses: Optional[list[ToolValidationResponse]] = None
    tool_validation_requests: Optional[list[ToolValidationRequest]] = None
    memory_fragment: Optional[MemoryFragment] = None
    block_id: str = None

@dataclass
class ToolCallValidationInfo:
    validated: bool
    allow_editing_inputs: bool
    edited_arguments: Optional[str] = None
