import copy

from govern.models import EnrichedArtifact
from govern.models import ScriptOutput

class AutogovernanceHandler:
    def __init__(self, enriched_artifact, client):
        """
        Instantiate a new autogovern hook handler.

        :param dict enriched_artifact: a Python dict of the dku enriched artifact to auto-govern
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """

        self.enrichedArtifact = EnrichedArtifact(copy.deepcopy(enriched_artifact))
        self.client = client
        self.message = ''
        self.status = 'SUCCESS'
        self.script_output = ScriptOutput()

instance = None

def get_autogovernance_handler():
    """
    Return the current instance of :class:`govern.core.AutogovernanceHandler`,
    previously set using :meth:`set_autogovernance_handler`

    :return: the instance of :class:`govern.core.AutogovernanceHandler` that was previously set with :meth:`set_autogovernance_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")

def set_autogovernance_handler(handler):
    """
    Set the current instance of :class:`govern.core.AutogovernanceHandler`

    :return: None
    """
    global instance
    instance = handler
