import dataiku
from dataiku.llm.agent_tools import BaseAgentTool


class MyAgentTool(BaseAgentTool):
    """A simple image generating agent tool"""

    def get_descriptor(self, tool):
        return {
            "description": "A simple image generating agent tool",
            "inputSchema": {
                "$id": "",
                "title": "",
                "type": "object",
                "properties": {},
                "required": []
            }
        }

    def invoke(self, input, trace):
        return {
            "output": "Image generated successfully",
            "parts": [{
                "type": "IMAGE_INLINE",
                "inlineImage": "iVBORw0KGgoAAAANSUhEUgAAABkAAAAZAQMAAAD+JxcgAAAAA1BMVEUd6bYeOlPlAAAAC0lEQVR42mMYSAAAAH0AAfaB9QAAAAAASUVORK5CYII=",
                "imageMimeType": "image/png",
            }, {
                "type": "TEXT",
                "text": "This is a picture of a teal square",
            }],
            "sources": [],
        }
