#!/bin/bash -e
# Install a locally-compiled version of Python 3.6 in an AlmaLinux 9 container image

PYTHON_VERSION="3.6.15"
PYTHON_MD5="f9e6f91c754a604f4fc6f6c7683723fb"

TMPDIR="/tmp.build-python36"

source /etc/os-release
case "$VERSION_ID" in
  8*) exit 0 ;; # Python 3.6 is installed by default in AlmaLinux8, so nothing to do here
  9*) repo="--enablerepo=crb" ;;
esac

yum -y --setopt=group_package_types="mandatory" $repo install \
  @development \
  bzip2-devel \
  gdbm-devel \
  libffi-devel \
  libuuid-devel \
  ncurses-devel \
  openssl-devel \
  readline-devel \
  sqlite-devel \
  xz-devel \
  zlib-devel \

mkdir -p "$TMPDIR"
cd "$TMPDIR"

curl -OsS "https://www.python.org/ftp/python/$PYTHON_VERSION/Python-$PYTHON_VERSION.tgz"
echo "$PYTHON_MD5 Python-$PYTHON_VERSION.tgz" | md5sum -c

tar xf Python-"$PYTHON_VERSION".tgz
cd Python-"$PYTHON_VERSION"

# Patch Python 3.6 due to byte alignment issue
cat > "$TMPDIR/python36.patch" << EOF
--- Include/obj.h
+++ Include/objimpl.h
@@ -250,7 +250,7 @@
         union _gc_head *gc_prev;
         Py_ssize_t gc_refs;
     } gc;
-    double dummy;  /* force worst-case alignment */
+    long double dummy;  /* force worst-case alignment */
 } PyGC_Head;

 extern PyGC_Head *_PyGC_generation0;
--- Objects/obmalloc.c
+++ Objects/obmalloc.c
@@ -643,8 +643,8 @@
  *
  * You shouldn't change this unless you know what you are doing.
  */
-#define ALIGNMENT               8               /* must be 2^N */
-#define ALIGNMENT_SHIFT         3
+#define ALIGNMENT               16               /* must be 2^N */
+#define ALIGNMENT_SHIFT         4

 /* Return the number of bytes in size class I, as a uint. */
 #define INDEX2SIZE(I) (((uint)(I) + 1) << ALIGNMENT_SHIFT)
EOF

patch -N -p0 < "$TMPDIR/python36.patch"

./configure
make -j 8
make altinstall

# Update built-in packages
/usr/local/bin/python3.6 -m pip install --upgrade pip setuptools

# Remove test module, except test.support which might be needed by additional packages
(cd /usr/local/lib/python3.6/test; ls | grep -vx support | xargs rm -rf)

(cd /usr/local/lib; rm -f libpython3.6*.a ; rm -f python3.6/config-3.6*-*/libpython3.6*.a ; find python3.6 -depth  -type f -name '*.pyc' -exec rm -f {} \;)

cd /
rm -rf "$TMPDIR"
yum clean all
