#!/bin/bash -e
# Install a locally-compiled version of Python 3.7 in an AlmaLinux 8 or 9 container image

PYTHON_VERSION="3.7.17"
PYTHON_MD5="19726591b0fb1a9658de68955fa8392a"

TMPDIR="/tmp.build-python37"

source /etc/os-release
case "$VERSION_ID" in
  8*) repo= ;;
  9*) repo="--enablerepo=crb" ;;
esac

yum -y --setopt=group_package_types="mandatory" $repo install \
  @development \
  bzip2-devel \
  gdbm-devel \
  libffi-devel \
  libuuid-devel \
  ncurses-devel \
  openssl-devel \
  readline-devel \
  sqlite-devel \
  xz-devel \
  zlib-devel \

mkdir -p "$TMPDIR"
cd "$TMPDIR"

curl -OsS "https://www.python.org/ftp/python/$PYTHON_VERSION/Python-$PYTHON_VERSION.tgz"
echo "$PYTHON_MD5 Python-$PYTHON_VERSION.tgz" | md5sum -c

tar xf Python-"$PYTHON_VERSION".tgz
cd Python-"$PYTHON_VERSION"

./configure
make -j 8
make altinstall

# Update built-in packages
/usr/local/bin/python3.7 -m pip install --upgrade pip setuptools

# Remove test module, except test.support which might be needed by additional packages
(cd /usr/local/lib/python3.7/test; ls | grep -vx support | xargs rm -rf)

(cd /usr/local/lib; rm -f libpython3.7*.a ; rm -f python3.7/config-3.7*-*/libpython3.7*.a ; find python3.7 -depth  -type f -name '*.pyc' -exec rm -f {} \;)

cd /
rm -rf "$TMPDIR"
yum clean all
