CREATE TABLE user_configuration (
    user_configuration_id TEXT PRIMARY KEY GENERATED ALWAYS AS ((user_configuration_json ->> 'userIdentifier')::TEXT) STORED,
    user_configuration_json JSONB NOT NULL
);
CREATE INDEX user_configuration_id_index ON user_configuration (user_configuration_id);

CREATE TABLE user_configuration_history (
    user_configuration_id TEXT GENERATED ALWAYS AS ((user_configuration_json ->> 'userIdentifier')::TEXT) STORED NOT NULL,
    user_configuration_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX user_configuration_history_id_index ON user_configuration_history (user_configuration_id);