from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...coremodel.simple_key_value.simple_key_value import SimpleKeyValue, _SimpleKeyValue
    from .output_handling import OutputHandling
from .block_graph_tool import BlockGraphTool, _BlockGraphTool

'''
Translated from class com.dataiku.dip.dao.SavedModel$BlockGraphReactTool
Via: com.dataiku.dip.dao.SavedModel$MandatoryToolCallBlock
'''


class _BlockGraphReactTool(_BlockGraphTool, TypedDict):
    additionalDescription: str
    agentId: str
    enableSetArgs: bool
    forwardContext: bool
    outputHandling: 'OutputHandling'
    outputToStoreInMessages: List['SimpleKeyValue']
    outputToStoreInScratchpad: List['SimpleKeyValue']
    outputToStoreInState: List['SimpleKeyValue']
    returnArtifacts: bool
    returnSources: bool
    setArgs: List['SimpleKeyValue']
    systemPromptPrepend: str
    treatAsJSON: bool


BlockGraphReactTool = _BlockGraphReactTool


# EOF
