from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .output_mode import OutputMode
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$DelegateToOtherAgentBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _DelegateToOtherAgentBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["DELEGATE_TO_OTHER_AGENT"]
    agentRef: str
    nextBlock: str
    outputMode: 'OutputMode'
    outputScratchpadKey: str
    outputStateKey: str
    streamOutput: bool


DelegateToOtherAgentBlock = _DelegateToOtherAgentBlock


# EOF
