from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...documenttemplating.document_templating_input.template_type import TemplateType
    from .artifact_output_format import ArtifactOutputFormat
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$GenerateArtifactBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _GenerateArtifactBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["GENERATE_ARTIFACT"]
    managedFolderRef: str
    nextBlock: str
    outputFilename: str
    outputFormat: 'ArtifactOutputFormat'
    outputManagedFolderRef: str
    template: str
    templateFilename: str
    templateType: 'TemplateType'


GenerateArtifactBlock = _GenerateArtifactBlock


# EOF
