from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....connections.hugging_face_local_connection.hugging_face_handling_mode import HuggingFaceHandlingMode
    from ....connections.hugging_face_local_connection.inference_settings import InferenceSettings, _InferenceSettings
    from .model_origin import ModelOrigin
from .hugging_face_kernel_command import HuggingFaceKernelCommand, _HuggingFaceKernelCommand

'''
Translated from class com.dataiku.dip.llm.local.HuggingFaceKernelClient$StartCommand
Via: PyModel annotation in the class hierarchy
'''


class _StartCommand(_HuggingFaceKernelCommand, TypedDict):
    type: Literal["start"]
    baseModelName: str
    baseModelPath: str
    batchSize: int
    fakeLLMServer: bool
    hfApiKey: NotRequired[Optional[str]]
    hfHandlingMode: 'HuggingFaceHandlingMode'
    hfModelName: str
    hfModelPath: str
    modelOrigin: 'ModelOrigin'
    modelSettings: 'InferenceSettings'
    savedModelId: str
    savedModelProjectKey: str
    savedModelVersionPath: str
    supportsImageInputs: bool
    useDSSModelCache: bool
    vllmVersion: str


StartCommand = _StartCommand


# EOF
