from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .abstract_tool import AbstractTool, _AbstractTool
    from .classification_output_mode import ClassificationOutputMode
    from .reasoning_effort import ReasoningEffort
    from .response_format import ResponseFormat, _ResponseFormat
    from .tool_choice import ToolChoice, _ToolChoice

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$CompletionSettings
Via: com.dataiku.dip.dao.SavedModel$ToolsUsingAgentSettings
'''


class _CompletionSettings(TypedDict):
    classLabels: NotRequired[Optional[List[str]]]
    customReasoningEffort: NotRequired[Optional[str]]
    frequencyPenalty: NotRequired[Optional[float]]
    hypothesisTemplate: NotRequired[Optional[str]]
    logProbs: NotRequired[Optional[bool]]
    logitBias: NotRequired[Optional[Dict[int, float]]]
    maxOutputTokens: NotRequired[Optional[int]]
    outputTrajectory: NotRequired[Optional[bool]]
    presencePenalty: NotRequired[Optional[float]]
    reasoningEffort: NotRequired[Optional['ReasoningEffort']]
    responseFormat: NotRequired[Optional['ResponseFormat']]
    stopSequences: NotRequired[Optional[List[str]]]
    summarizationMaxNumSplitLevels: NotRequired[Optional[int]]
    summarizationMaxTokens: NotRequired[Optional[int]]
    summarizationMinTokens: NotRequired[Optional[int]]
    summarizationNumOverlapTokens: NotRequired[Optional[int]]
    summarizationSpecialTokensSafetyFactor: NotRequired[Optional[int]]
    temperature: NotRequired[Optional[float]]
    textClassificationOutputMode: NotRequired[Optional['ClassificationOutputMode']]
    toolChoice: NotRequired[Optional['ToolChoice']]
    tools: NotRequired[Optional[List['AbstractTool']]]
    topK: NotRequired[Optional[int]]
    topLogProbs: NotRequired[Optional[int]]
    topP: NotRequired[Optional[float]]


CompletionSettings = _CompletionSettings


# EOF
