from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....utils.smart_log_tail.smart_log_tail import SmartLogTail, _SmartLogTail
    from .abstract_tool_call import AbstractToolCall, _AbstractToolCall
    from .artifact import Artifact, _Artifact
    from .detailed_log_prob import DetailedLogProb, _DetailedLogProb
    from .finish_reason import FinishReason
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan
    from .memory_fragment import MemoryFragment, _MemoryFragment
    from .predicted_class_proba import PredictedClassProba, _PredictedClassProba
    from .simple_completion_response_or_error import SimpleCompletionResponseOrError, _SimpleCompletionResponseOrError
    from .source import Source, _Source
    from .tool_validation_request import ToolValidationRequest, _ToolValidationRequest
    from .total_usage import TotalUsage, _TotalUsage
from .usage_metadata import UsageMetadata, _UsageMetadata

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$SimpleCompletionResponse
Via: PyModel annotation in the class hierarchy
'''


class _SimpleCompletionResponse(_UsageMetadata, TypedDict):
    additionalInformation: NotRequired[Optional[Dict[str, Any]]]
    artifacts: List['Artifact']
    contextUpsert: NotRequired[Optional[Dict[str, Any]]]
    finishReason: 'FinishReason'
    fromCache: bool
    log: 'SmartLogTail'
    logProbs: NotRequired[Optional[List['DetailedLogProb']]]
    memoryFragment: NotRequired[Optional['MemoryFragment']]
    predictedClass: str
    predictedClassProbas: List['PredictedClassProba']
    reportedUsageMetadata: 'UsageMetadata'
    sources: NotRequired[Optional[List['Source']]]
    text: NotRequired[Optional[str]]
    toolCalls: NotRequired[Optional[List['AbstractToolCall']]]
    toolValidationRequests: NotRequired[Optional[List['ToolValidationRequest']]]
    totalUsage: 'TotalUsage'
    trace: 'LLMMeshTraceSpan'


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$SimpleCompletionResponse
SimpleCompletionResponse = Union[
    '_SimpleCompletionResponse',
    'SimpleCompletionResponseOrError',
]


# EOF
