package __CLASSPACKAGE__;

import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.custom.CustomUserAuthenticator;

/**
 * Authenticate a user from an external user store into DSS.
 * The user from the external user store needs to be mapped into user identity.
 */
public class __CLASSNAME__ implements CustomUserAuthenticator {

    /**
     * Authenticate a user using login/password credential.
     * Fetch the user from the external user store and map it into a DSS user identity.
     *
     * @param inputLogin The user login
     * @param password The user password
     * @return the user identity corresponding from the external user store.
     * @throws ServerAuthenticationFailure if an unexpected error occurs
     * @throws UserAuthenticationException if the credentials couldn't match an existing user in the external user store
     */
    @Override
    public UserIdentity authenticate(String inputLogin, String password) throws ServerAuthenticationFailure, UserAuthenticationException {
        //Authenticate and fetch the user  from the external source.

        //You know need to map the user from the external source into a DSS User identity object.
        //This is important in case the user needs to be provisioned/sync
        UserIdentity userIdentity = new UserIdentity(UserSourceType.CUSTOM, inputLogin);
        userIdentity.email = "Get the email from your external user";
        userIdentity.displayName = "Get the display from your external user";
        return userIdentity;
    }
}
