from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...llm.online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from .block_graph_react_tool import BlockGraphReactTool, _BlockGraphReactTool
    from .output_mode import OutputMode
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$MandatoryToolCallBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _MandatoryToolCallBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["MANDATORY_TOOL_CALL"]
    completionSettings: 'CompletionSettings'
    llmId: str
    nextBlock: str
    outputMode: 'OutputMode'
    outputScratchpadKey: str
    outputStateKey: str
    stateAware: bool
    systemPrompt: str
    tool: 'BlockGraphReactTool'


MandatoryToolCallBlock = _MandatoryToolCallBlock


# EOF
