from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...llm.online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from .output_mode import OutputMode
    from .reflection_mode import ReflectionMode
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$ReflectionBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _ReflectionBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["REFLECTION"]
    critiqueCompletionSettings: 'CompletionSettings'
    critiqueMaxIterations: int
    expectationsPrompt: str
    failOnMaxIterations: bool
    generatorBlockId: str
    llmId: str
    maxThreads: int
    mode: 'ReflectionMode'
    nextBlock: str
    outputMode: 'OutputMode'
    outputScratchpadKey: str
    outputStateKey: str
    streamOutput: bool
    synthesizeCompletionSettings: 'CompletionSettings'
    synthesizeIterations: int
    synthesizePrompt: str


ReflectionBlock = _ReflectionBlock


# EOF
