from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .block_graph_react_tool import BlockGraphReactTool, _BlockGraphReactTool
    from .react_block_exit_condition import ReactBlockExitCondition, _ReactBlockExitCondition
from .llm_base_block import LLMBaseBlock, _LLMBaseBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$StandardReactBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _StandardReactBlock(_LLMBaseBlock, TypedDict):
    type: Literal["STANDARD_REACT"]
    defaultNextBlock: str
    exitConditions: List['ReactBlockExitCondition']
    maxLoopIterations: int
    maxParallelToolExecutions: int
    scratchpadAware: bool
    stateAware: bool
    tools: List['BlockGraphReactTool']


StandardReactBlock = _StandardReactBlock


# EOF
