from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..isotonic_curve.parametrized_isotonic_curve import ParametrizedIsotonicCurve, _ParametrizedIsotonicCurve
    from ..polynomial_curve.parametrized_polynomial_curve import ParametrizedPolynomialCurve, _ParametrizedPolynomialCurve
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.curves.Curve$ParametrizedCurve
Via: com.dataiku.dip.eda.compute.computations.bivariate.FitCurve$FitCurveResult
'''


class _ParametrizedCurve(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.curves.Curve$ParametrizedCurve
ParametrizedCurve = Union[
    'ParametrizedIsotonicCurve',
    'ParametrizedPolynomialCurve',
]

# Types of class com.dataiku.dip.eda.compute.curves.Curve$ParametrizedCurve in PolyJSON mappings (as literal type)
ParametrizedCurveTypeLiteral = Literal["isotonic", "polynomial", ]


# EOF
