from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....worksheets.models.binning_mode.binning_mode import BinningMode
from ..grouping.grouping import Grouping, _Grouping

'''
Translated from class com.dataiku.dip.eda.compute.grouping.BinnedGrouping
Via: com.dataiku.dip.eda.compute.grouping.Grouping
'''


class _BinnedGrouping(_Grouping, TypedDict):
    type: Literal["binned"]
    column: str
    customBounds: NotRequired[Optional[List[float]]]
    keepNA: bool
    mode: 'BinningMode'
    nbBins: NotRequired[Optional[int]]


BinnedGrouping = _BinnedGrouping


# EOF
