from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..anum_grouping.anum_grouping import AnumGrouping, _AnumGrouping
    from ..binned_grouping.binned_grouping import BinnedGrouping, _BinnedGrouping
    from ..cross_grouping.cross_grouping import CrossGrouping, _CrossGrouping
    from ..merge_grouping.merge_grouping import MergeGrouping, _MergeGrouping
    from ..multi_anum_grouping.multi_anum_grouping import MultiAnumGrouping, _MultiAnumGrouping
    from ..subsampled_grouping.subsampled_grouping import SubsampledGrouping, _SubsampledGrouping
    from ..subset_grouping.subset_grouping import SubsetGrouping, _SubsetGrouping
    from ..top_n_time_grouping.top_n_time_grouping import TopNTimeGrouping, _TopNTimeGrouping
    from ..union_grouping.union_grouping import UnionGrouping, _UnionGrouping
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.grouping.Grouping
Via: com.dataiku.dip.eda.compute.computations.bivariate.Chi2IndTest
'''


class _Grouping(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.grouping.Grouping
Grouping = Union[
    'AnumGrouping',
    'BinnedGrouping',
    'CrossGrouping',
    'MergeGrouping',
    'MultiAnumGrouping',
    'SubsampledGrouping',
    'SubsetGrouping',
    'TopNTimeGrouping',
    'UnionGrouping',
]

# Types of class com.dataiku.dip.eda.compute.grouping.Grouping in PolyJSON mappings (as literal type)
GroupingTypeLiteral = Literal["anum", "binned", "cross", "merge", "multi_anum", "subsampled", "subset", "topn_time", "union", ]


# EOF
