from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .auto_tool_choice import AutoToolChoice, _AutoToolChoice
    from .named_tool_choice import NamedToolChoice, _NamedToolChoice
    from .none_tool_choice import NoneToolChoice, _NoneToolChoice
    from .required_tool_choice import RequiredToolChoice, _RequiredToolChoice

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$ToolChoice
Via: com.dataiku.dip.llm.online.LLMClient$CompletionSettings
'''


class _ToolChoice(TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$ToolChoice
ToolChoice = Union[
    'AutoToolChoice',
    'NamedToolChoice',
    'NoneToolChoice',
    'RequiredToolChoice',
]

# Types of class com.dataiku.dip.llm.online.LLMClient$ToolChoice in PolyJSON mappings (as literal type)
ToolChoiceTypeLiteral = Literal["auto", "tool_name", "none", "required", ]


# EOF
