/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.ReplLoadWork;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.EventDumpDirComparator;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.parse.repl.load.log.IncrementalLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class ReplicationSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private String dbNameOrPattern;
    private String tblNameOrPattern;
    private Long eventFrom;
    private Long eventTo;
    private Integer maxEventLimit;
    private String path;
    private HiveConf conf;
    private Hive db;
    private static String testInjectDumpDir = null;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";
    public static final String FUNCTIONS_ROOT_DIR_NAME = "_functions";
    public static final String CONSTRAINTS_ROOT_DIR_NAME = "_constraints";

    ReplicationSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.db = ((BaseSemanticAnalyzer)this).db;
        this.conf = new HiveConf(((BaseSemanticAnalyzer)this).conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAanalyzer: analyzeInternal");
        this.LOG.debug(ast.getName() + ":" + ast.getToken().getText() + "=" + ast.getText());
        switch (ast.getToken().getType()) {
            case 966: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: dump");
                try {
                    this.initReplDump(ast);
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), e);
                }
                this.analyzeReplDump(ast);
                break;
            }
            case 967: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: load");
                this.initReplLoad(ast);
                this.analyzeReplLoad(ast);
                break;
            }
            case 968: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: status");
                this.initReplStatus(ast);
                this.analyzeReplStatus(ast);
                break;
            }
            default: {
                throw new SemanticException("Unexpected root token");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initReplDump(ASTNode ast) throws HiveException {
        int numChildren = ast.getChildCount();
        boolean isMetaDataOnly = false;
        this.dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        for (int currNode = 1; currNode < numChildren; ++currNode) {
            void var6_8;
            if (ast.getChild(currNode).getType() == 964) {
                HashMap<String, String> replConfigs = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(currNode).getChild(0));
                if (null == replConfigs) continue;
                for (Map.Entry config : replConfigs.entrySet()) {
                    this.conf.set((String)config.getKey(), (String)config.getValue());
                }
                isMetaDataOnly = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY);
                continue;
            }
            if (ast.getChild(currNode).getType() == 1061) {
                this.tblNameOrPattern = PlanUtils.stripQuotes(ast.getChild(currNode).getChild(0).getText());
                continue;
            }
            Tree fromNode = ast.getChild(currNode);
            this.eventFrom = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild(0).getText()));
            boolean bl = true;
            while (var6_8 < fromNode.getChildCount()) {
                if (fromNode.getChild((int)var6_8).getType() == 1074) {
                    this.eventTo = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild((int)(var6_8 + true)).getText()));
                    ++var6_8;
                } else if (fromNode.getChild((int)var6_8).getType() == 886) {
                    this.maxEventLimit = Integer.parseInt(PlanUtils.stripQuotes(fromNode.getChild((int)(var6_8 + true)).getText()));
                    ++var6_8;
                }
                ++var6_8;
            }
        }
        for (String string : Utils.matchesDb(this.db, this.dbNameOrPattern)) {
            Database database = this.db.getDatabase(string);
            if (database != null) {
                if (isMetaDataOnly || ReplChangeManager.isSourceOfReplication(database)) continue;
                this.LOG.error("Cannot dump database " + string + " as it is not a source of replication (repl.source.for)");
                throw new SemanticException(ErrorMsg.REPL_DATABASE_IS_NOT_SOURCE_OF_REPLICATION.getMsg());
            }
            throw new SemanticException("Cannot dump database " + string + " as it does not exist");
        }
    }

    private void analyzeReplDump(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplDump: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern) + " from " + String.valueOf(this.eventFrom) + " to " + String.valueOf(this.eventTo) + " maxEventLimit " + String.valueOf(this.maxEventLimit));
        try {
            this.ctx.setResFile(this.ctx.getLocalTmpPath());
            Task<ReplDumpWork> replDumpWorkTask = TaskFactory.get(new ReplDumpWork(this.dbNameOrPattern, this.tblNameOrPattern, this.eventFrom, this.eventTo, ErrorMsg.INVALID_PATH.getMsg(ast), this.maxEventLimit, this.ctx.getResFile().toUri().toString()), this.conf);
            this.rootTasks.add(replDumpWorkTask);
            if (this.dbNameOrPattern != null) {
                for (String string : Utils.matchesDb(this.db, this.dbNameOrPattern)) {
                    if (this.tblNameOrPattern != null) {
                        for (String string2 : Utils.matchesTbl(this.db, string, this.tblNameOrPattern)) {
                            this.inputs.add(new ReadEntity(this.db.getTable(string, string2)));
                        }
                        continue;
                    }
                    this.inputs.add(new ReadEntity(this.db.getDatabase(string)));
                }
            }
            this.setFetchTask(this.createFetchTask(dumpSchema));
        }
        catch (Exception e) {
            this.LOG.warn("Error during analyzeReplDump", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    private void initReplLoad(ASTNode ast) throws SemanticException {
        this.path = PlanUtils.stripQuotes(ast.getChild(0).getText());
        int numChildren = ast.getChildCount();
        block7: for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 799: {
                    this.dbNameOrPattern = PlanUtils.stripQuotes(childNode.getChild(0).getText());
                    continue block7;
                }
                case 1061: {
                    this.tblNameOrPattern = PlanUtils.stripQuotes(childNode.getChild(0).getText());
                    continue block7;
                }
                case 964: {
                    HashMap<String, String> replConfigs = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    if (null == replConfigs) continue block7;
                    for (Map.Entry config : replConfigs.entrySet()) {
                        this.conf.set((String)config.getKey(), (String)config.getValue());
                    }
                    try {
                        this.db = Hive.get(this.conf);
                        continue block7;
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                }
                default: {
                    throw new SemanticException("Unrecognized token in REPL LOAD statement");
                }
            }
        }
    }

    private boolean isEventNotReplayed(Map<String, String> params, FileStatus dir, DumpType dumpType) {
        String replLastId;
        if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString()) && Long.parseLong(replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString())) >= Long.parseLong(dir.getPath().getName())) {
            this.LOG.debug("Event " + (Object)((Object)dumpType) + " with replId " + Long.parseLong(dir.getPath().getName()) + " is already replayed. LastReplId - " + Long.parseLong(replLastId));
            return false;
        }
        return true;
    }

    private boolean shouldReplayEvent(FileStatus dir, DumpType dumpType) throws SemanticException {
        if (this.dbNameOrPattern == null || this.dbNameOrPattern.isEmpty()) {
            return true;
        }
        if (this.tblNameOrPattern == null || this.tblNameOrPattern.isEmpty()) {
            try {
                Database database = Hive.get().getDatabase(this.dbNameOrPattern);
                return this.isEventNotReplayed(database.getParameters(), dir, dumpType);
            }
            catch (HiveException e) {
                this.LOG.debug("failed to get the database " + this.dbNameOrPattern);
                return true;
            }
        }
        try {
            Table tbl = Hive.get().getTable(this.dbNameOrPattern, this.tblNameOrPattern);
            return this.isEventNotReplayed(tbl.getParameters(), dir, dumpType);
        }
        catch (HiveException e) {
            this.LOG.debug("failed to get the table " + this.dbNameOrPattern + "." + this.tblNameOrPattern);
            return true;
        }
    }

    private void analyzeReplLoad(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplSemanticAnalyzer.analyzeReplLoad: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern) + " from " + String.valueOf(this.path));
        try {
            assert (this.path != null);
            Path loadPath = new Path(this.path);
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            if (!fs.exists(loadPath = fs.makeQualified(loadPath))) {
                this.LOG.error("File not found " + loadPath.toUri().toString());
                throw new FileNotFoundException(ErrorMsg.REPL_LOAD_PATH_NOT_FOUND.getMsg());
            }
            DumpMetaData dmd = new DumpMetaData(loadPath, this.conf);
            boolean evDump = false;
            if (dmd.isIncrementalDump()) {
                this.LOG.debug("{} contains an incremental dump", (Object)loadPath);
                evDump = true;
            } else {
                this.LOG.debug("{} contains an bootstrap dump", (Object)loadPath);
            }
            if (!evDump && this.tblNameOrPattern != null && !this.tblNameOrPattern.isEmpty()) {
                ReplLoadWork replLoadWork = new ReplLoadWork(this.conf, loadPath.toString(), this.dbNameOrPattern, this.tblNameOrPattern, this.queryState.getLineageState());
                this.rootTasks.add(TaskFactory.get(replLoadWork, this.conf));
                return;
            }
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(fs, loadPath);
            if (srcs == null || srcs.length == 0) {
                this.LOG.warn("Nothing to load at {}", (Object)loadPath.toUri().toString());
                return;
            }
            FileStatus[] dirsInLoadPath = fs.listStatus(loadPath, EximUtil.getDirectoryFilter(fs));
            if (dirsInLoadPath == null || dirsInLoadPath.length == 0) {
                throw new IllegalArgumentException("No data to load in path " + loadPath.toUri().toString());
            }
            if (!evDump) {
                if (this.dbNameOrPattern != null && dirsInLoadPath.length > 1) {
                    this.LOG.debug("Found multiple dirs when we expected 1:");
                    for (FileStatus d : dirsInLoadPath) {
                        this.LOG.debug("> " + d.getPath().toUri().toString());
                    }
                    throw new IllegalArgumentException("Multiple dirs in " + loadPath.toUri().toString() + " does not correspond to REPL LOAD expecting to load to a singular destination point.");
                }
                ReplLoadWork replLoadWork = new ReplLoadWork(this.conf, loadPath.toString(), this.dbNameOrPattern, this.queryState.getLineageState());
                this.rootTasks.add(TaskFactory.get(replLoadWork, this.conf));
            } else {
                Task<DependencyCollectionWork> evTaskRoot;
                Arrays.sort(dirsInLoadPath, new EventDumpDirComparator());
                Task<Serializable> taskChainTail = evTaskRoot = TaskFactory.get(new DependencyCollectionWork());
                IncrementalLoadLogger replLogger = new IncrementalLoadLogger(this.dbNameOrPattern, loadPath.toString(), dirsInLoadPath.length);
                for (FileStatus dir : dirsInLoadPath) {
                    String locn = dir.getPath().toUri().toString();
                    DumpMetaData eventDmd = new DumpMetaData(new Path(locn), this.conf);
                    if (!this.shouldReplayEvent(dir, eventDmd.getDumpType())) continue;
                    this.LOG.debug("Loading event from {} to {}.{}", new Object[]{dir.getPath().toUri(), this.dbNameOrPattern, this.tblNameOrPattern});
                    MessageHandler.Context context = new MessageHandler.Context(this.dbNameOrPattern, this.tblNameOrPattern, locn, taskChainTail, eventDmd, this.conf, this.db, this.ctx, this.LOG);
                    List<Task<? extends Serializable>> evTasks = this.analyzeEventLoad(context);
                    if (evTasks == null || evTasks.isEmpty()) continue;
                    ReplStateLogWork replStateLogWork = new ReplStateLogWork((ReplLogger)replLogger, dir.getPath().getName(), eventDmd.getDumpType().toString());
                    Task<ReplStateLogWork> barrierTask = TaskFactory.get(replStateLogWork);
                    for (Task<? extends Serializable> t : evTasks) {
                        t.addDependentTask(barrierTask);
                        this.LOG.debug("Added {}:{} as a precursor of barrier task {}:{}", new Object[]{t.getClass(), t.getId(), barrierTask.getClass(), barrierTask.getId()});
                    }
                    this.LOG.debug("Updated taskChainTail from {}:{} to {}:{}", new Object[]{taskChainTail.getClass(), taskChainTail.getId(), barrierTask.getClass(), barrierTask.getId()});
                    taskChainTail = barrierTask;
                }
                if (!evTaskRoot.equals(taskChainTail)) {
                    HashMap<String, String> dbProps = new HashMap<String, String>();
                    dbProps.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), String.valueOf(dmd.getEventTo()));
                    ReplStateLogWork replStateLogWork = new ReplStateLogWork((ReplLogger)replLogger, dbProps);
                    Task<ReplStateLogWork> barrierTask = TaskFactory.get(replStateLogWork, this.conf);
                    taskChainTail.addDependentTask(barrierTask);
                    this.LOG.debug("Added {}:{} as a precursor of barrier task {}:{}", new Object[]{taskChainTail.getClass(), taskChainTail.getId(), barrierTask.getClass(), barrierTask.getId()});
                    ((ReplLogger)replLogger).startLog();
                }
                this.rootTasks.add(evTaskRoot);
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private List<Task<? extends Serializable>> analyzeEventLoad(MessageHandler.Context context) throws SemanticException {
        MessageHandler messageHandler = context.dmd.getDumpType().handler();
        List<Task<? extends Serializable>> tasks = messageHandler.handle(context);
        if (context.precursor != null) {
            for (Task<? extends Serializable> t : tasks) {
                context.precursor.addDependentTask(t);
                this.LOG.debug("Added {}:{} as a precursor of {}:{}", new Object[]{context.precursor.getClass(), context.precursor.getId(), t.getClass(), t.getId()});
            }
        }
        this.inputs.addAll(messageHandler.readEntities());
        this.outputs.addAll(messageHandler.writeEntities());
        return this.addUpdateReplStateTasks(StringUtils.isEmpty(context.tableName), messageHandler.getUpdatedMetadata(), tasks);
    }

    private Task<? extends Serializable> tableUpdateReplStateTask(String dbName, String tableName, Map<String, String> partSpec, String replState, Task<? extends Serializable> preCursor) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), replState);
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, new ReplicationSpec(replState, replState));
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        alterTblDesc.setPartSpec((HashMap)partSpec);
        Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, alterTblDesc), this.conf);
        if (preCursor != null) {
            preCursor.addDependentTask(updateReplIdTask);
            this.LOG.debug("Added {}:{} as a precursor of {}:{}", new Object[]{preCursor.getClass(), preCursor.getId(), updateReplIdTask.getClass(), updateReplIdTask.getId()});
        }
        return updateReplIdTask;
    }

    private Task<? extends Serializable> dbUpdateReplStateTask(String dbName, String replState, Task<? extends Serializable> preCursor) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), replState);
        AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbName, mapProp, new ReplicationSpec(replState, replState));
        Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, alterDbDesc), this.conf);
        if (preCursor != null) {
            preCursor.addDependentTask(updateReplIdTask);
            this.LOG.debug("Added {}:{} as a precursor of {}:{}", new Object[]{preCursor.getClass(), preCursor.getId(), updateReplIdTask.getClass(), updateReplIdTask.getId()});
        }
        return updateReplIdTask;
    }

    private List<Task<? extends Serializable>> addUpdateReplStateTasks(boolean isDatabaseLoad, UpdatedMetaDataTracker updatedMetadata, List<Task<? extends Serializable>> importTasks) throws SemanticException {
        Task<? extends Serializable> updateReplIdTask;
        String replState = updatedMetadata.getReplicationState();
        String dbName = updatedMetadata.getDatabase();
        String tableName = updatedMetadata.getTable();
        if (importTasks.isEmpty() || !isDatabaseLoad && tableName == null) {
            this.LOG.debug("No objects need update of repl state: Either 0 import tasks or table level load");
            return importTasks;
        }
        Task<DependencyCollectionWork> barrierTask = TaskFactory.get(new DependencyCollectionWork());
        for (Task<? extends Serializable> t : importTasks) {
            t.addDependentTask(barrierTask);
            this.LOG.debug("Added {}:{} as a precursor of barrier task {}:{}", new Object[]{t.getClass(), t.getId(), barrierTask.getClass(), barrierTask.getId()});
        }
        ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
        for (Map<String, String> partSpec : updatedMetadata.getPartitions()) {
            updateReplIdTask = this.tableUpdateReplStateTask(dbName, tableName, partSpec, replState, barrierTask);
            tasks.add(updateReplIdTask);
        }
        if (tableName != null) {
            updateReplIdTask = this.tableUpdateReplStateTask(dbName, tableName, null, replState, barrierTask);
            tasks.add(updateReplIdTask);
        }
        if (isDatabaseLoad) {
            updateReplIdTask = this.dbUpdateReplStateTask(dbName, replState, barrierTask);
            tasks.add(updateReplIdTask);
        }
        return tasks;
    }

    private void initReplStatus(ASTNode ast) throws SemanticException {
        this.dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        int numChildren = ast.getChildCount();
        block6: for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 1061: {
                    this.tblNameOrPattern = PlanUtils.stripQuotes(childNode.getChild(0).getText());
                    continue block6;
                }
                case 964: {
                    HashMap<String, String> replConfigs = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    if (null == replConfigs) continue block6;
                    for (Map.Entry config : replConfigs.entrySet()) {
                        this.conf.set((String)config.getKey(), (String)config.getValue());
                    }
                    try {
                        this.db = Hive.get(this.conf);
                        continue block6;
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                }
                default: {
                    throw new SemanticException("Unrecognized token in REPL STATUS statement");
                }
            }
        }
    }

    private void analyzeReplStatus(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern));
        String replLastId = null;
        try {
            if (this.tblNameOrPattern != null) {
                Table tbl = this.db.getTable(this.dbNameOrPattern, this.tblNameOrPattern);
                if (tbl != null) {
                    this.inputs.add(new ReadEntity(tbl));
                    Map<String, String> params = tbl.getParameters();
                    if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                        replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                    }
                }
            } else {
                Database database = this.db.getDatabase(this.dbNameOrPattern);
                if (database != null) {
                    this.inputs.add(new ReadEntity(database));
                    Map<String, String> params = database.getParameters();
                    if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                        replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                    }
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        this.prepareReturnValues(Collections.singletonList(replLastId), "last_repl_id#string");
        this.setFetchTask(this.createFetchTask("last_repl_id#string"));
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: writing repl.last.id={} out to {}", new Object[]{String.valueOf(replLastId), this.ctx.getResFile(), this.conf});
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Utils.writeOutput(values, this.ctx.getResFile(), this.conf);
    }
}

