/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AutoValue_AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;

@AutoValue
public abstract class AsyncWriteChannelOptions {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final int BUFFER_SIZE_DEFAULT = 0x800000;
    public static final int PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    private static final int PARALLEL_COMPOSITE_UPLOAD_BUFFER_COUNT = 1;
    private static final int PARALLEL_COMPOSITE_UPLOAD_BUFFER_CAPACITY = 0x2000000;
    public static final int UPLOAD_CHUNK_SIZE_GRANULARITY = 0x800000;
    private static final String PART_FILE_PREFIX = "";
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x800000 : 0x4000000;
    public static final int UPLOAD_CACHE_SIZE_DEFAULT = 0;
    public static final boolean DIRECT_UPLOAD_ENABLED_DEFAULT = false;
    public static final boolean GRPC_CHECKSUMS_ENABLED_DEFAULT = false;
    public static final long DEFAULT_GRPC_WRITE_TIMEOUT = 600000L;
    public static final long DEFAULT_NUM_REQUESTS_BUFFERED_GRPC = 20L;
    public static final long DEFAULT_GRPC_WRITE_MESSAGE_TIMEOUT_MILLIS = 3000L;
    public static final PipeType PIPE_TYPE_DEFAULT = PipeType.IO_STREAM_PIPE;
    public static final AsyncWriteChannelOptions DEFAULT = AsyncWriteChannelOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_AsyncWriteChannelOptions.Builder().setBufferSize(0x800000).setPipeBufferSize(0x100000).setPipeType(PIPE_TYPE_DEFAULT).setUploadChunkSize(UPLOAD_CHUNK_SIZE_DEFAULT).setUploadCacheSize(0).setDirectUploadEnabled(false).setGrpcChecksumsEnabled(false).setGrpcWriteTimeout(600000L).setNumberOfBufferedRequests(20L).setGrpcWriteMessageTimeoutMillis(3000L).setUploadType(UploadType.CHUNK_UPLOAD).setTemporaryPaths(ImmutableSet.of()).setPCUBufferCount(1).setPCUBufferCapacity(0x2000000).setPartFileCleanupType(PartFileCleanupType.ALWAYS).setPartFileNamePrefix(PART_FILE_PREFIX);
    }

    public abstract Builder toBuilder();

    public abstract int getBufferSize();

    public abstract int getPipeBufferSize();

    public abstract PipeType getPipeType();

    public abstract int getUploadChunkSize();

    public abstract int getUploadCacheSize();

    public abstract boolean isDirectUploadEnabled();

    public abstract boolean isGrpcChecksumsEnabled();

    public abstract long getGrpcWriteTimeout();

    public abstract long getNumberOfBufferedRequests();

    public abstract long getGrpcWriteMessageTimeoutMillis();

    public abstract UploadType getUploadType();

    public abstract PartFileCleanupType getPartFileCleanupType();

    public abstract ImmutableSet<String> getTemporaryPaths();

    public abstract int getPCUBufferCount();

    public abstract int getPCUBufferCapacity();

    public abstract String getPartFileNamePrefix();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBufferSize(int var1);

        public abstract Builder setPipeBufferSize(int var1);

        public abstract Builder setPipeType(PipeType var1);

        public abstract Builder setUploadChunkSize(int var1);

        public abstract Builder setUploadCacheSize(int var1);

        public abstract Builder setDirectUploadEnabled(boolean var1);

        public abstract Builder setGrpcWriteTimeout(long var1);

        public abstract Builder setNumberOfBufferedRequests(long var1);

        public abstract Builder setGrpcChecksumsEnabled(boolean var1);

        public abstract Builder setGrpcWriteMessageTimeoutMillis(long var1);

        public abstract Builder setUploadType(UploadType var1);

        public abstract Builder setPartFileCleanupType(PartFileCleanupType var1);

        public abstract Builder setTemporaryPaths(ImmutableSet<String> var1);

        public abstract Builder setPCUBufferCount(int var1);

        public abstract Builder setPCUBufferCapacity(int var1);

        public abstract Builder setPartFileNamePrefix(String var1);

        abstract AsyncWriteChannelOptions autoBuild();

        public AsyncWriteChannelOptions build() {
            AsyncWriteChannelOptions options = this.autoBuild();
            Builder.checkUploadChunkSize(options.getUploadChunkSize());
            return options;
        }

        private static void checkUploadChunkSize(int chunkSize) {
            Preconditions.checkArgument(chunkSize > 0, "Upload chunk size must be great than 0, but was $%s", chunkSize);
            Preconditions.checkArgument(chunkSize % 262144 == 0, "Upload chunk size must be a multiple of %s", 262144);
            if (chunkSize > 0x800000 && chunkSize % 0x800000 != 0) {
                ((GoogleLogger.Api)logger.atWarning()).log("Upload chunk size should be a multiple of %s for the best performance, got %s", 0x800000, chunkSize);
            }
        }
    }

    public static enum UploadType {
        CHUNK_UPLOAD,
        WRITE_TO_DISK_THEN_UPLOAD,
        JOURNALING,
        PARALLEL_COMPOSITE_UPLOAD;

    }

    public static enum PartFileCleanupType {
        ALWAYS,
        NEVER,
        ON_SUCCESS;

    }

    public static enum PipeType {
        NIO_CHANNEL_PIPE,
        IO_STREAM_PIPE;

    }
}

