/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class StorageByteChannels {
    StorageByteChannels() {
    }

    static Readable readable() {
        return Readable.INSTANCE;
    }

    static Writable writable() {
        return Writable.INSTANCE;
    }

    static final class Readable {
        private static final Readable INSTANCE = new Readable();

        private Readable() {
        }

        public BufferedReadableByteChannelSession.BufferedReadableByteChannel createSynchronized(BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate) {
            return new SynchronizedBufferedReadableByteChannel(delegate);
        }

        public UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel createSynchronized(UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate) {
            return new SynchronizedUnbufferedReadableByteChannel(delegate);
        }

        public ScatteringByteChannel asScatteringByteChannel(ReadableByteChannel c) {
            return new ScatteringByteChannelFacade(c);
        }
    }

    static final class Writable {
        private static final Writable INSTANCE = new Writable();

        private Writable() {
        }

        public BufferedWritableByteChannelSession.BufferedWritableByteChannel createSynchronized(BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate) {
            return new SynchronizedBufferedWritableByteChannel(delegate);
        }

        public UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel createSynchronized(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate) {
            return new SynchronizedUnbufferedWritableByteChannel(delegate);
        }
    }

    private static final class ScatteringByteChannelFacade
    implements ScatteringByteChannel {
        private final ReadableByteChannel c;

        private ScatteringByteChannelFacade(ReadableByteChannel c) {
            this.c = c;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return Math.toIntExact(this.read(new ByteBuffer[]{dst}, 0, 1));
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (!this.c.isOpen()) {
                throw new ClosedChannelException();
            }
            long totalBytesRead = 0L;
            for (int i = offset; i < length; ++i) {
                ByteBuffer dst = dsts[i];
                int goal = dst.remaining();
                if (!dst.hasRemaining()) continue;
                int read = this.c.read(dst);
                if (read == -1) {
                    if (totalBytesRead != 0L) break;
                    this.c.close();
                    return -1L;
                }
                if (read != goal) {
                    return totalBytesRead + (long)read;
                }
                totalBytesRead += (long)read;
            }
            return totalBytesRead;
        }

        @Override
        public boolean isOpen() {
            return this.c.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.c.close();
        }
    }

    private static final class SynchronizedUnbufferedWritableByteChannel
    implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
        private final UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate;

        private SynchronizedUnbufferedWritableByteChannel(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public synchronized long write(ByteBuffer[] srcs) throws IOException {
            return this.delegate.write(srcs);
        }

        @Override
        public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public synchronized int writeAndClose(ByteBuffer src) throws IOException {
            return this.delegate.writeAndClose(src);
        }

        @Override
        public synchronized long writeAndClose(ByteBuffer[] srcs) throws IOException {
            return this.delegate.writeAndClose(srcs);
        }

        @Override
        public synchronized long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.writeAndClose(srcs, offset, length);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public synchronized void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class SynchronizedUnbufferedReadableByteChannel
    implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
        private final UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate;

        private SynchronizedUnbufferedReadableByteChannel(UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized int read(ByteBuffer src) throws IOException {
            return this.delegate.read(src);
        }

        @Override
        public synchronized long read(ByteBuffer[] dsts) throws IOException {
            return this.delegate.read(dsts);
        }

        @Override
        public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public synchronized void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class SynchronizedBufferedWritableByteChannel
    implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
        private final BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate;

        public SynchronizedBufferedWritableByteChannel(BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public synchronized void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public synchronized void flush() throws IOException {
            this.delegate.flush();
        }
    }

    private static final class SynchronizedBufferedReadableByteChannel
    implements BufferedReadableByteChannelSession.BufferedReadableByteChannel {
        private final BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate;

        public SynchronizedBufferedReadableByteChannel(BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public synchronized void close() throws IOException {
            this.delegate.close();
        }
    }
}

