/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.stats;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Timestamp;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.data.AttachmentValue;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.data.Exemplar;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.export.Distribution;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.export.Point;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.export.Value;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.AggregationData;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.BucketBoundaries;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

abstract class MutableAggregation {
    private static final double TOLERANCE = 1.0E-6;

    private MutableAggregation() {
    }

    abstract void add(double var1, Map<String, AttachmentValue> var3, Timestamp var4);

    abstract void combine(MutableAggregation var1, double var2);

    abstract AggregationData toAggregationData();

    abstract Point toPoint(Timestamp var1);

    static final class MutableLastValueLong
    extends MutableLastValueDouble {
        private MutableLastValueLong() {
        }

        static MutableLastValueLong create() {
            return new MutableLastValueLong();
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.LastValueDataLong.create(Math.round(this.getLastValue()));
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.longValue(Math.round(this.getLastValue())), timestamp);
        }
    }

    static class MutableLastValueDouble
    extends MutableAggregation {
        private double lastValue = Double.NaN;
        private boolean initialized = false;

        private MutableLastValueDouble() {
        }

        static MutableLastValueDouble create() {
            return new MutableLastValueDouble();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            this.lastValue = value;
            if (!this.initialized) {
                this.initialized = true;
            }
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument(other instanceof MutableLastValueDouble, "MutableLastValueDouble expected.");
            MutableLastValueDouble otherValue = (MutableLastValueDouble)other;
            this.lastValue = otherValue.initialized ? otherValue.getLastValue() : this.lastValue;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.LastValueDataDouble.create(this.lastValue);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.doubleValue(this.lastValue), timestamp);
        }

        @VisibleForTesting
        double getLastValue() {
            return this.lastValue;
        }
    }

    static final class MutableDistribution
    extends MutableAggregation {
        private double sum = 0.0;
        private double mean = 0.0;
        private long count = 0L;
        private double sumOfSquaredDeviations = 0.0;
        private final BucketBoundaries bucketBoundaries;
        private final long[] bucketCounts;
        @Nullable
        private final Exemplar[] exemplars;

        private MutableDistribution(BucketBoundaries bucketBoundaries) {
            this.bucketBoundaries = bucketBoundaries;
            int buckets = bucketBoundaries.getBoundaries().size() + 1;
            this.bucketCounts = new long[buckets];
            this.exemplars = bucketBoundaries.getBoundaries().isEmpty() ? null : new Exemplar[buckets];
        }

        static MutableDistribution create(BucketBoundaries bucketBoundaries) {
            Preconditions.checkNotNull(bucketBoundaries, "bucketBoundaries should not be null.");
            return new MutableDistribution(bucketBoundaries);
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            int bucket;
            this.sum += value;
            ++this.count;
            double deltaFromMean = value - this.mean;
            this.mean += deltaFromMean / (double)this.count;
            double deltaFromMean2 = value - this.mean;
            this.sumOfSquaredDeviations += deltaFromMean * deltaFromMean2;
            for (bucket = 0; bucket < this.bucketBoundaries.getBoundaries().size() && !(value < this.bucketBoundaries.getBoundaries().get(bucket)); ++bucket) {
            }
            int n = bucket;
            this.bucketCounts[n] = this.bucketCounts[n] + 1L;
            if (!attachments.isEmpty() && this.exemplars != null) {
                this.exemplars[bucket] = Exemplar.create(value, timestamp, attachments);
            }
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument(other instanceof MutableDistribution, "MutableDistribution expected.");
            if (Math.abs(1.0 - fraction) > 1.0E-6) {
                return;
            }
            MutableDistribution mutableDistribution = (MutableDistribution)other;
            Preconditions.checkArgument(this.bucketBoundaries.equals(mutableDistribution.bucketBoundaries), "Bucket boundaries should match.");
            if (this.count + mutableDistribution.count > 0L) {
                double delta = mutableDistribution.mean - this.mean;
                this.sumOfSquaredDeviations = this.sumOfSquaredDeviations + mutableDistribution.sumOfSquaredDeviations + Math.pow(delta, 2.0) * (double)this.count * (double)mutableDistribution.count / (double)(this.count + mutableDistribution.count);
            }
            this.count += mutableDistribution.count;
            this.sum += mutableDistribution.sum;
            this.mean = this.sum / (double)this.count;
            long[] bucketCounts = mutableDistribution.getBucketCounts();
            for (int i = 0; i < bucketCounts.length; ++i) {
                int n = i;
                this.bucketCounts[n] = this.bucketCounts[n] + bucketCounts[i];
            }
            Exemplar[] otherExemplars = mutableDistribution.getExemplars();
            if (this.exemplars != null && otherExemplars != null) {
                for (int i = 0; i < otherExemplars.length; ++i) {
                    Exemplar exemplar = otherExemplars[i];
                    if (exemplar == null) continue;
                    this.exemplars[i] = exemplar;
                }
            }
        }

        @Override
        AggregationData toAggregationData() {
            ArrayList<Long> boxedBucketCounts = new ArrayList<Long>();
            for (long bucketCount : this.bucketCounts) {
                boxedBucketCounts.add(bucketCount);
            }
            ArrayList<Exemplar> exemplarList = new ArrayList<Exemplar>();
            if (this.exemplars != null) {
                for (Exemplar exemplar : this.exemplars) {
                    if (exemplar == null) continue;
                    exemplarList.add(exemplar);
                }
            }
            return AggregationData.DistributionData.create(this.mean, this.count, this.sumOfSquaredDeviations, boxedBucketCounts, exemplarList);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            ArrayList<Distribution.Bucket> buckets = new ArrayList<Distribution.Bucket>();
            for (int bucket = 0; bucket < this.bucketCounts.length; ++bucket) {
                long bucketCount = this.bucketCounts[bucket];
                Exemplar exemplar = null;
                if (this.exemplars != null) {
                    exemplar = this.exemplars[bucket];
                }
                Distribution.Bucket metricBucket = exemplar != null ? Distribution.Bucket.create(bucketCount, exemplar) : Distribution.Bucket.create(bucketCount);
                buckets.add(metricBucket);
            }
            Distribution.BucketOptions bucketOptions = Distribution.BucketOptions.explicitOptions(this.bucketBoundaries.getBoundaries());
            return Point.create(Value.distributionValue(Distribution.create(this.count, this.mean * (double)this.count, this.sumOfSquaredDeviations, bucketOptions, buckets)), timestamp);
        }

        double getMean() {
            return this.mean;
        }

        long getCount() {
            return this.count;
        }

        double getSumOfSquaredDeviations() {
            return this.sumOfSquaredDeviations;
        }

        long[] getBucketCounts() {
            return this.bucketCounts;
        }

        BucketBoundaries getBucketBoundaries() {
            return this.bucketBoundaries;
        }

        @Nullable
        Exemplar[] getExemplars() {
            return this.exemplars;
        }
    }

    static final class MutableMean
    extends MutableAggregation {
        private double sum = 0.0;
        private long count = 0L;

        private MutableMean() {
        }

        static MutableMean create() {
            return new MutableMean();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            ++this.count;
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument(other instanceof MutableMean, "MutableMean expected.");
            MutableMean mutableMean = (MutableMean)other;
            this.count += Math.round((double)mutableMean.count * fraction);
            this.sum += mutableMean.sum * fraction;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.MeanData.create(this.getMean(), this.count);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.doubleValue(this.getMean()), timestamp);
        }

        double getMean() {
            return this.count == 0L ? 0.0 : this.sum / (double)this.count;
        }

        long getCount() {
            return this.count;
        }

        @VisibleForTesting
        double getSum() {
            return this.sum;
        }
    }

    static final class MutableCount
    extends MutableAggregation {
        private long count = 0L;

        private MutableCount() {
        }

        static MutableCount create() {
            return new MutableCount();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            ++this.count;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument(other instanceof MutableCount, "MutableCount expected.");
            this.count += Math.round(fraction * (double)((MutableCount)other).getCount());
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.CountData.create(this.count);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.longValue(this.count), timestamp);
        }

        long getCount() {
            return this.count;
        }
    }

    static final class MutableSumLong
    extends MutableSumDouble {
        private MutableSumLong() {
        }

        static MutableSumLong create() {
            return new MutableSumLong();
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.SumDataLong.create(Math.round(this.getSum()));
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.longValue(Math.round(this.getSum())), timestamp);
        }
    }

    static class MutableSumDouble
    extends MutableAggregation {
        private double sum = 0.0;

        private MutableSumDouble() {
        }

        static MutableSumDouble create() {
            return new MutableSumDouble();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument(other instanceof MutableSumDouble, "MutableSumDouble expected.");
            this.sum += fraction * ((MutableSumDouble)other).sum;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.SumDataDouble.create(this.sum);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create(Value.doubleValue(this.sum), timestamp);
        }

        @VisibleForTesting
        double getSum() {
            return this.sum;
        }
    }
}

