/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsApacheHttpExpect100Exception;
import org.apache.hadoop.fs.azurebfs.services.AbfsApacheHttpClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsAHCHttpOperation
extends AbfsHttpOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsAHCHttpOperation.class);
    private final HttpRequestBase httpRequestBase;
    private HttpResponse httpResponse;
    private final boolean isPayloadRequest;
    private final AbfsApacheHttpClient abfsApacheHttpClient;

    public AbfsAHCHttpOperation(URL url, String method, List<AbfsHttpHeader> requestHeaders, Duration connectionTimeout, Duration readTimeout, AbfsApacheHttpClient abfsApacheHttpClient) throws IOException {
        super(LOG, url, method, requestHeaders, connectionTimeout, readTimeout);
        URI requestUri;
        this.isPayloadRequest = "PUT".equals(method) || "PATCH".equals(method) || "POST".equals(method);
        this.abfsApacheHttpClient = abfsApacheHttpClient;
        LOG.debug("Creating AbfsAHCHttpOperation for URL: {}, method: {}", (Object)url, (Object)method);
        try {
            requestUri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        switch (this.getMethod()) {
            case "PUT": {
                this.httpRequestBase = new HttpPut(requestUri);
                break;
            }
            case "PATCH": {
                this.httpRequestBase = new HttpPatch(requestUri);
                break;
            }
            case "POST": {
                this.httpRequestBase = new HttpPost(requestUri);
                break;
            }
            case "GET": {
                this.httpRequestBase = new HttpGet(requestUri);
                break;
            }
            case "DELETE": {
                this.httpRequestBase = new HttpDelete(requestUri);
                break;
            }
            case "HEAD": {
                this.httpRequestBase = new HttpHead(requestUri);
                break;
            }
            default: {
                throw new PathIOException(this.getUrl().toString(), "Unsupported HTTP method: " + this.getMethod());
            }
        }
    }

    @VisibleForTesting
    AbfsManagedHttpClientContext getHttpClientContext() {
        return new AbfsManagedHttpClientContext();
    }

    @Override
    protected InputStream getErrorStream() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getContent();
    }

    @Override
    String getConnProperty(String key) {
        for (AbfsHttpHeader header : this.getRequestHeaders()) {
            if (!header.getName().equals(key)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    URL getConnUrl() {
        return this.getUrl();
    }

    @Override
    Integer getConnResponseCode() throws IOException {
        return this.getStatusCode();
    }

    @Override
    String getConnResponseMessage() throws IOException {
        return this.getStatusDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        try {
            if (!this.isPayloadRequest) {
                this.prepareRequest();
                LOG.debug("Sending request: {}", (Object)this.httpRequestBase);
                this.httpResponse = this.executeRequest();
                LOG.debug("Request sent: {}; response {}", (Object)this.httpRequestBase, (Object)this.httpResponse);
            }
            this.parseResponseHeaderAndBody(buffer, offset, length);
        }
        finally {
            if (this.httpResponse != null) {
                try {
                    EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                }
                finally {
                    if (this.httpResponse instanceof CloseableHttpResponse) {
                        ((CloseableHttpResponse)this.httpResponse).close();
                    }
                }
            }
        }
    }

    @VisibleForTesting
    void parseResponseHeaderAndBody(byte[] buffer, int offset, int length) throws IOException {
        this.setStatusCode(this.parseStatusCode(this.httpResponse));
        this.setStatusDescription(this.httpResponse.getStatusLine().getReasonPhrase());
        this.setRequestId();
        if (LOG.isDebugEnabled()) {
            AbfsIoUtils.dumpHeadersToDebugLog("Request Headers", this.getRequestProperties());
        }
        this.parseResponse(buffer, offset, length);
    }

    @VisibleForTesting
    int parseStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    @VisibleForTesting
    HttpResponse executeRequest() throws IOException {
        AbfsManagedHttpClientContext abfsHttpClientContext = this.getHttpClientContext();
        try {
            LOG.debug("Executing request: {}", (Object)this.httpRequestBase);
            HttpResponse response = this.abfsApacheHttpClient.execute(this.httpRequestBase, abfsHttpClientContext, this.getConnectionTimeout(), this.getReadTimeout());
            this.setConnectionTimeMs(abfsHttpClientContext.getConnectTime());
            this.setSendRequestTimeMs(abfsHttpClientContext.getSendTime());
            this.setRecvResponseTimeMs(abfsHttpClientContext.getReadTime());
            return response;
        }
        catch (IOException e) {
            LOG.debug("Failed to execute request: {}", (Object)this.httpRequestBase, (Object)e);
            throw e;
        }
    }

    @Override
    public void setRequestProperty(String key, String value) {
        List<AbfsHttpHeader> headers = this.getRequestHeaders();
        if (headers != null) {
            headers.add(new AbfsHttpHeader(key, value));
        }
    }

    @Override
    Map<String, List<String>> getRequestProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (final AbfsHttpHeader header : this.getRequestHeaders()) {
            map.put(header.getName(), (List<String>)new ArrayList<String>(){
                {
                    this.add(header.getValue());
                }
            });
        }
        return map;
    }

    @Override
    public String getResponseHeader(String headerName) {
        if (this.httpResponse == null) {
            return null;
        }
        Header header = this.httpResponse.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    protected InputStream getContentInputStream() throws IOException {
        if (this.httpResponse == null || this.httpResponse.getEntity() == null) {
            return null;
        }
        return this.httpResponse.getEntity().getContent();
    }

    @Override
    public void sendPayload(byte[] buffer, int offset, int length) throws IOException {
        if (!this.isPayloadRequest) {
            return;
        }
        this.setExpectedBytesToBeSent(length);
        if (buffer != null) {
            ByteArrayEntity httpEntity = new ByteArrayEntity(buffer, offset, length, ContentType.TEXT_PLAIN);
            ((HttpEntityEnclosingRequestBase)this.httpRequestBase).setEntity((HttpEntity)httpEntity);
        }
        this.prepareRequest();
        try {
            LOG.debug("Sending request: {}", (Object)this.httpRequestBase);
            this.httpResponse = this.executeRequest();
        }
        catch (AbfsApacheHttpExpect100Exception ex) {
            LOG.debug("Getting output stream failed with expect header enabled, returning back.Expect 100 assertion failed for uri {} with status code: {}", new Object[]{this.getMaskedUrl(), this.parseStatusCode(ex.getHttpResponse()), ex});
            this.setConnectionDisconnectedOnError();
            this.httpResponse = ex.getHttpResponse();
        }
        catch (IOException ex) {
            LOG.debug("Getting output stream failed for uri {}, exception: {}", (Object)this.getMaskedUrl(), (Object)ex);
            throw ex;
        }
        finally {
            if (this.httpResponse != null) {
                LOG.debug("Request sent: {}; response {}", (Object)this.httpRequestBase, (Object)this.httpResponse);
            }
            if (!this.isConnectionDisconnectedOnError() && this.httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
                this.setBytesSent(length);
            }
        }
    }

    private void prepareRequest() {
        for (AbfsHttpHeader header : this.getRequestHeaders()) {
            this.httpRequestBase.setHeader(header.getName(), header.getValue());
        }
    }

    @Override
    public String getRequestProperty(String name) {
        for (AbfsHttpHeader header : this.getRequestHeaders()) {
            if (!header.getName().equals(name)) continue;
            return header.getValue();
        }
        return "";
    }

    @Override
    public String getTracingContextSuffix() {
        return "Apache";
    }
}

