/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.hadoop.util.wrapped.io.FutureIO;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class HadoopInputFile
implements InputFile {
    private static final String OPENFILE_READ_POLICY_KEY = "fs.option.openfile.read.policy";
    private static final String PARQUET_READ_POLICY = "parquet, vector, random, adaptive";
    private final FileSystem fs;
    private final FileStatus stat;
    private final Configuration conf;

    public static HadoopInputFile fromPath(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        return new HadoopInputFile(fs, fs.getFileStatus(path), conf);
    }

    public static HadoopInputFile fromPathUnchecked(Path path, Configuration conf) {
        try {
            return HadoopInputFile.fromPath(path, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopInputFile fromStatus(FileStatus stat, Configuration conf) throws IOException {
        FileSystem fs = stat.getPath().getFileSystem(conf);
        return new HadoopInputFile(fs, stat, conf);
    }

    private HadoopInputFile(FileSystem fs, FileStatus stat, Configuration conf) {
        this.fs = fs;
        this.stat = stat;
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getPath() {
        return this.stat.getPath();
    }

    @Override
    public long getLength() {
        return this.stat.getLen();
    }

    @Override
    public SeekableInputStream newStream() throws IOException {
        FSDataInputStream stream;
        try {
            CompletableFuture future = ((FutureDataInputStreamBuilder)this.fs.openFile(this.stat.getPath()).withFileStatus(this.stat).opt(OPENFILE_READ_POLICY_KEY, PARQUET_READ_POLICY)).build();
            stream = (FSDataInputStream)FutureIO.awaitFuture(future);
        }
        catch (RuntimeException e) {
            try {
                stream = this.fs.open(this.stat.getPath());
            }
            catch (IOException | RuntimeException ex) {
                ex.addSuppressed(e);
                throw ex;
            }
        }
        return HadoopStreams.wrap(stream);
    }

    public String toString() {
        return this.stat.getPath().toString();
    }
}

