/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.converters;

import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.ConverterUtils;
import com.amazonaws.services.glue.model.BinaryColumnStatisticsData;
import com.amazonaws.services.glue.model.BooleanColumnStatisticsData;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.ColumnStatisticsType;
import com.amazonaws.services.glue.model.DateColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalNumber;
import com.amazonaws.services.glue.model.DoubleColumnStatisticsData;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.LongColumnStatisticsData;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PrincipalType;
import com.amazonaws.services.glue.model.ResourceUri;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.StringColumnStatisticsData;
import com.amazonaws.services.glue.model.UserDefinedFunction;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;

public class BaseCatalogToHiveConverter
implements CatalogToHiveConverter {
    private static final Logger logger = Logger.getLogger(BaseCatalogToHiveConverter.class);
    private static final ImmutableMap<String, HiveException> EXCEPTION_MAP = ImmutableMap.builder().put((Object)"AlreadyExistsException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new AlreadyExistsException(msg);
        }
    }).put((Object)"InvalidInputException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new InvalidObjectException(msg);
        }
    }).put((Object)"InternalServiceException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new MetaException(msg);
        }
    }).put((Object)"ResourceNumberLimitExceededException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new MetaException(msg);
        }
    }).put((Object)"OperationTimeoutException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new MetaException(msg);
        }
    }).put((Object)"EntityNotFoundException", (Object)new HiveException(){

        @Override
        public TException get(String msg) {
            return new NoSuchObjectException(msg);
        }
    }).build();

    @Override
    public TException wrapInHiveException(Throwable e) {
        return this.getHiveException(e.getClass().getSimpleName(), e.getMessage());
    }

    @Override
    public TException errorDetailToHiveException(ErrorDetail errorDetail) {
        return this.getHiveException(errorDetail.getErrorCode(), errorDetail.getErrorMessage());
    }

    private TException getHiveException(String errorName, String errorMsg) {
        if (EXCEPTION_MAP.containsKey((Object)errorName)) {
            return ((HiveException)EXCEPTION_MAP.get((Object)errorName)).get(errorMsg);
        }
        logger.warn((Object)("Hive Exception type not found for " + errorName));
        return new MetaException(errorMsg);
    }

    @Override
    public Database convertDatabase(com.amazonaws.services.glue.model.Database catalogDatabase) {
        Database hiveDatabase = new Database();
        hiveDatabase.setName(catalogDatabase.getName());
        hiveDatabase.setDescription(catalogDatabase.getDescription());
        String location = catalogDatabase.getLocationUri();
        hiveDatabase.setLocationUri(location == null ? "" : location);
        hiveDatabase.setParameters((Map)ObjectUtils.firstNonNull((Object[])new Map[]{catalogDatabase.getParameters(), Maps.newHashMap()}));
        return hiveDatabase;
    }

    public FieldSchema convertFieldSchema(Column catalogFieldSchema) {
        FieldSchema hiveFieldSchema = new FieldSchema();
        hiveFieldSchema.setType(catalogFieldSchema.getType());
        hiveFieldSchema.setName(catalogFieldSchema.getName());
        hiveFieldSchema.setComment(catalogFieldSchema.getComment());
        return hiveFieldSchema;
    }

    @Override
    public List<FieldSchema> convertFieldSchemaList(List<Column> catalogFieldSchemaList) {
        ArrayList<FieldSchema> hiveFieldSchemaList = new ArrayList<FieldSchema>();
        if (catalogFieldSchemaList == null) {
            return hiveFieldSchemaList;
        }
        for (Column catalogFieldSchema : catalogFieldSchemaList) {
            hiveFieldSchemaList.add(this.convertFieldSchema(catalogFieldSchema));
        }
        return hiveFieldSchemaList;
    }

    @Override
    public Table convertTable(com.amazonaws.services.glue.model.Table catalogTable, String dbname) {
        Table hiveTable = new Table();
        hiveTable.setDbName(dbname);
        hiveTable.setTableName(catalogTable.getName());
        Date createTime = catalogTable.getCreateTime();
        hiveTable.setCreateTime(createTime == null ? 0 : (int)(createTime.getTime() / 1000L));
        hiveTable.setOwner(catalogTable.getOwner());
        Date lastAccessedTime = catalogTable.getLastAccessTime();
        hiveTable.setLastAccessTime(lastAccessedTime == null ? 0 : (int)(lastAccessedTime.getTime() / 1000L));
        hiveTable.setRetention(catalogTable.getRetention().intValue());
        hiveTable.setSd(this.convertStorageDescriptor(catalogTable.getStorageDescriptor()));
        hiveTable.setPartitionKeys(this.convertFieldSchemaList(catalogTable.getPartitionKeys()));
        Map parameterMap = catalogTable.getParameters();
        if (parameterMap == null) {
            parameterMap = Maps.newHashMap();
        }
        hiveTable.setParameters(parameterMap);
        hiveTable.setViewOriginalText(catalogTable.getViewOriginalText());
        hiveTable.setViewExpandedText(catalogTable.getViewExpandedText());
        hiveTable.setTableType(catalogTable.getTableType());
        return hiveTable;
    }

    @Override
    public TableMeta convertTableMeta(com.amazonaws.services.glue.model.Table catalogTable, String dbName) {
        TableMeta tableMeta = new TableMeta();
        tableMeta.setDbName(dbName);
        tableMeta.setTableName(catalogTable.getName());
        tableMeta.setTableType(catalogTable.getTableType());
        if (catalogTable.getParameters().containsKey("comment")) {
            tableMeta.setComments((String)catalogTable.getParameters().get("comment"));
        }
        return tableMeta;
    }

    public org.apache.hadoop.hive.metastore.api.StorageDescriptor convertStorageDescriptor(StorageDescriptor catalogSd) {
        org.apache.hadoop.hive.metastore.api.StorageDescriptor hiveSd = new org.apache.hadoop.hive.metastore.api.StorageDescriptor();
        hiveSd.setCols(this.convertFieldSchemaList(catalogSd.getColumns()));
        hiveSd.setLocation(catalogSd.getLocation());
        hiveSd.setInputFormat(catalogSd.getInputFormat());
        hiveSd.setOutputFormat(catalogSd.getOutputFormat());
        hiveSd.setCompressed(catalogSd.getCompressed().booleanValue());
        hiveSd.setNumBuckets(catalogSd.getNumberOfBuckets().intValue());
        hiveSd.setSerdeInfo(this.convertSerDeInfo(catalogSd.getSerdeInfo()));
        hiveSd.setBucketCols((List)ObjectUtils.firstNonNull((Object[])new List[]{catalogSd.getBucketColumns(), Lists.newArrayList()}));
        hiveSd.setSortCols(this.convertOrderList(catalogSd.getSortColumns()));
        hiveSd.setParameters((Map)ObjectUtils.firstNonNull((Object[])new Map[]{catalogSd.getParameters(), Maps.newHashMap()}));
        hiveSd.setSkewedInfo(this.convertSkewedInfo(catalogSd.getSkewedInfo()));
        hiveSd.setStoredAsSubDirectories(catalogSd.getStoredAsSubDirectories().booleanValue());
        return hiveSd;
    }

    public org.apache.hadoop.hive.metastore.api.Order convertOrder(Order catalogOrder) {
        org.apache.hadoop.hive.metastore.api.Order hiveOrder = new org.apache.hadoop.hive.metastore.api.Order();
        hiveOrder.setCol(catalogOrder.getColumn());
        hiveOrder.setOrder(catalogOrder.getSortOrder().intValue());
        return hiveOrder;
    }

    public List<org.apache.hadoop.hive.metastore.api.Order> convertOrderList(List<Order> catalogOrderList) {
        ArrayList<org.apache.hadoop.hive.metastore.api.Order> hiveOrderList = new ArrayList<org.apache.hadoop.hive.metastore.api.Order>();
        if (catalogOrderList == null) {
            return hiveOrderList;
        }
        for (Order catalogOrder : catalogOrderList) {
            hiveOrderList.add(this.convertOrder(catalogOrder));
        }
        return hiveOrderList;
    }

    public org.apache.hadoop.hive.metastore.api.SerDeInfo convertSerDeInfo(SerDeInfo catalogSerDeInfo) {
        org.apache.hadoop.hive.metastore.api.SerDeInfo hiveSerDeInfo = new org.apache.hadoop.hive.metastore.api.SerDeInfo();
        hiveSerDeInfo.setName(catalogSerDeInfo.getName());
        hiveSerDeInfo.setParameters((Map)ObjectUtils.firstNonNull((Object[])new Map[]{catalogSerDeInfo.getParameters(), Maps.newHashMap()}));
        hiveSerDeInfo.setSerializationLib(catalogSerDeInfo.getSerializationLibrary());
        return hiveSerDeInfo;
    }

    public SkewedInfo convertSkewedInfo(com.amazonaws.services.glue.model.SkewedInfo catalogSkewedInfo) {
        if (catalogSkewedInfo == null) {
            return null;
        }
        SkewedInfo hiveSkewedInfo = new SkewedInfo();
        hiveSkewedInfo.setSkewedColNames((List)ObjectUtils.firstNonNull((Object[])new List[]{catalogSkewedInfo.getSkewedColumnNames(), Lists.newArrayList()}));
        hiveSkewedInfo.setSkewedColValues(this.convertSkewedValue(catalogSkewedInfo.getSkewedColumnValues()));
        hiveSkewedInfo.setSkewedColValueLocationMaps(this.convertSkewedMap(catalogSkewedInfo.getSkewedColumnValueLocationMaps()));
        return hiveSkewedInfo;
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Partition convertPartition(Partition src) {
        org.apache.hadoop.hive.metastore.api.Partition tgt = new org.apache.hadoop.hive.metastore.api.Partition();
        Date createTime = src.getCreationTime();
        if (createTime != null) {
            tgt.setCreateTime((int)(createTime.getTime() / 1000L));
            tgt.setCreateTimeIsSet(true);
        } else {
            tgt.setCreateTimeIsSet(false);
        }
        String dbName = src.getDatabaseName();
        if (dbName != null) {
            tgt.setDbName(dbName);
            tgt.setDbNameIsSet(true);
        } else {
            tgt.setDbNameIsSet(false);
        }
        Date lastAccessTime = src.getLastAccessTime();
        if (lastAccessTime != null) {
            tgt.setLastAccessTime((int)(lastAccessTime.getTime() / 1000L));
            tgt.setLastAccessTimeIsSet(true);
        } else {
            tgt.setLastAccessTimeIsSet(false);
        }
        Map params = src.getParameters();
        if (params == null) {
            params = Maps.newHashMap();
        }
        tgt.setParameters(params);
        tgt.setParametersIsSet(true);
        String tableName = src.getTableName();
        if (tableName != null) {
            tgt.setTableName(tableName);
            tgt.setTableNameIsSet(true);
        } else {
            tgt.setTableNameIsSet(false);
        }
        List values = src.getValues();
        if (values != null) {
            tgt.setValues(values);
            tgt.setValuesIsSet(true);
        } else {
            tgt.setValuesIsSet(false);
        }
        StorageDescriptor sd = src.getStorageDescriptor();
        if (sd != null) {
            org.apache.hadoop.hive.metastore.api.StorageDescriptor hiveSd = this.convertStorageDescriptor(sd);
            tgt.setSd(hiveSd);
            tgt.setSdIsSet(true);
        } else {
            tgt.setSdIsSet(false);
        }
        return tgt;
    }

    @Override
    public List<org.apache.hadoop.hive.metastore.api.Partition> convertPartitions(List<Partition> src) {
        if (src == null) {
            return null;
        }
        ArrayList target = Lists.newArrayList();
        for (Partition partition : src) {
            target.add(this.convertPartition(partition));
        }
        return target;
    }

    public List<String> convertStringToList(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<String> listString = new ArrayList<String>();
        int i = 0;
        block0: while (i < s.length()) {
            StringBuilder length = new StringBuilder();
            for (int j = i; j < s.length(); ++j) {
                if (s.charAt(j) == '$') {
                    int lengthOfString = Integer.valueOf(length.toString());
                    listString.add(s.substring(j + 1, j + 1 + lengthOfString));
                    i = j + 1 + lengthOfString;
                    continue block0;
                }
                length.append(s.charAt(j));
            }
        }
        return listString;
    }

    @Nonnull
    public Map<List<String>, String> convertSkewedMap(@Nullable Map<String, String> catalogSkewedMap) {
        HashMap<List<String>, String> skewedMap = new HashMap<List<String>, String>();
        if (catalogSkewedMap == null) {
            return skewedMap;
        }
        for (String coralKey : catalogSkewedMap.keySet()) {
            skewedMap.put(this.convertStringToList(coralKey), catalogSkewedMap.get(coralKey));
        }
        return skewedMap;
    }

    @Nonnull
    public List<List<String>> convertSkewedValue(@Nullable List<String> catalogSkewedValue) {
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        if (catalogSkewedValue == null) {
            return skewedValues;
        }
        for (String skewValue : catalogSkewedValue) {
            skewedValues.add(this.convertStringToList(skewValue));
        }
        return skewedValues;
    }

    public org.apache.hadoop.hive.metastore.api.PrincipalType convertPrincipalType(PrincipalType catalogPrincipalType) {
        if (catalogPrincipalType == null) {
            return null;
        }
        if (catalogPrincipalType == PrincipalType.GROUP) {
            return org.apache.hadoop.hive.metastore.api.PrincipalType.GROUP;
        }
        if (catalogPrincipalType == PrincipalType.USER) {
            return org.apache.hadoop.hive.metastore.api.PrincipalType.USER;
        }
        if (catalogPrincipalType == PrincipalType.ROLE) {
            return org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE;
        }
        throw new RuntimeException("Unknown principal type:" + catalogPrincipalType.name());
    }

    @Override
    public Function convertFunction(String dbName, UserDefinedFunction catalogFunction) {
        if (catalogFunction == null) {
            return null;
        }
        Function hiveFunction = new Function();
        hiveFunction.setClassName(catalogFunction.getClassName());
        if (catalogFunction.getCreateTime() != null) {
            hiveFunction.setCreateTime((int)(catalogFunction.getCreateTime().getTime() / 1000L));
        }
        hiveFunction.setDbName(dbName);
        hiveFunction.setFunctionName(catalogFunction.getFunctionName());
        hiveFunction.setFunctionType(FunctionType.JAVA);
        hiveFunction.setOwnerName(catalogFunction.getOwnerName());
        hiveFunction.setOwnerType(this.convertPrincipalType(PrincipalType.fromValue((String)catalogFunction.getOwnerType())));
        hiveFunction.setResourceUris(this.convertResourceUriList(catalogFunction.getResourceUris()));
        return hiveFunction;
    }

    public List<org.apache.hadoop.hive.metastore.api.ResourceUri> convertResourceUriList(List<ResourceUri> catalogResourceUriList) {
        if (catalogResourceUriList == null) {
            return null;
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.ResourceUri> hiveResourceUriList = new ArrayList<org.apache.hadoop.hive.metastore.api.ResourceUri>();
        for (ResourceUri catalogResourceUri : catalogResourceUriList) {
            org.apache.hadoop.hive.metastore.api.ResourceUri hiveResourceUri = new org.apache.hadoop.hive.metastore.api.ResourceUri();
            hiveResourceUri.setUri(catalogResourceUri.getUri());
            if (catalogResourceUri.getResourceType() != null) {
                hiveResourceUri.setResourceType(ResourceType.valueOf((String)catalogResourceUri.getResourceType()));
            }
            hiveResourceUriList.add(hiveResourceUri);
        }
        return hiveResourceUriList;
    }

    @Override
    public List<ColumnStatisticsObj> convertColumnStatisticsList(List<ColumnStatistics> catatlogColumnStatisticsList) {
        ArrayList<ColumnStatisticsObj> hiveColumnStatisticsList = new ArrayList<ColumnStatisticsObj>();
        for (ColumnStatistics catalogColumnStatistics : catatlogColumnStatisticsList) {
            ColumnStatisticsObj hiveColumnStatistics = new ColumnStatisticsObj();
            hiveColumnStatistics.setColName(catalogColumnStatistics.getColumnName());
            hiveColumnStatistics.setColType(catalogColumnStatistics.getColumnType());
            hiveColumnStatistics.setStatsData(this.convertColumnStatisticsData(catalogColumnStatistics.getStatisticsData()));
            hiveColumnStatisticsList.add(hiveColumnStatistics);
        }
        return hiveColumnStatisticsList;
    }

    private ColumnStatisticsData convertColumnStatisticsData(com.amazonaws.services.glue.model.ColumnStatisticsData catalogColumnStatisticsData) {
        ColumnStatisticsData hiveColumnStatisticsData = new ColumnStatisticsData();
        ColumnStatisticsType type = ColumnStatisticsType.fromValue((String)catalogColumnStatisticsData.getType());
        switch (type) {
            case BINARY: {
                BinaryColumnStatisticsData catalogBinaryData = catalogColumnStatisticsData.getBinaryColumnStatisticsData();
                BinaryColumnStatsData hiveBinaryData = new BinaryColumnStatsData();
                hiveBinaryData.setAvgColLen(catalogBinaryData.getAverageLength().doubleValue());
                hiveBinaryData.setMaxColLen(catalogBinaryData.getMaximumLength().longValue());
                hiveBinaryData.setNumNulls(catalogBinaryData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setFieldValue((TFieldIdEnum)ColumnStatisticsData._Fields.BINARY_STATS, (Object)hiveBinaryData);
                hiveColumnStatisticsData.setBinaryStats(hiveBinaryData);
                break;
            }
            case BOOLEAN: {
                BooleanColumnStatisticsData catalogBooleanData = catalogColumnStatisticsData.getBooleanColumnStatisticsData();
                BooleanColumnStatsData hiveBooleanData = new BooleanColumnStatsData();
                hiveBooleanData.setNumFalses(catalogBooleanData.getNumberOfFalses().longValue());
                hiveBooleanData.setNumTrues(catalogBooleanData.getNumberOfTrues().longValue());
                hiveBooleanData.setNumNulls(catalogBooleanData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setBooleanStats(hiveBooleanData);
                break;
            }
            case DATE: {
                DateColumnStatisticsData catalogDateData = catalogColumnStatisticsData.getDateColumnStatisticsData();
                DateColumnStatsData hiveDateData = new DateColumnStatsData();
                hiveDateData.setLowValue(ConverterUtils.dateToHiveDate(catalogDateData.getMinimumValue()));
                hiveDateData.setHighValue(ConverterUtils.dateToHiveDate(catalogDateData.getMaximumValue()));
                hiveDateData.setNumDVs(catalogDateData.getNumberOfDistinctValues().longValue());
                hiveDateData.setNumNulls(catalogDateData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setDateStats(hiveDateData);
                break;
            }
            case DECIMAL: {
                DecimalColumnStatisticsData catalogDecimalData = catalogColumnStatisticsData.getDecimalColumnStatisticsData();
                DecimalColumnStatsData hiveDecimalData = new DecimalColumnStatsData();
                hiveDecimalData.setLowValue(this.convertDecimal(catalogDecimalData.getMinimumValue()));
                hiveDecimalData.setHighValue(this.convertDecimal(catalogDecimalData.getMaximumValue()));
                hiveDecimalData.setNumDVs(catalogDecimalData.getNumberOfDistinctValues().longValue());
                hiveDecimalData.setNumNulls(catalogDecimalData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setDecimalStats(hiveDecimalData);
                break;
            }
            case DOUBLE: {
                DoubleColumnStatisticsData catalogDoubleData = catalogColumnStatisticsData.getDoubleColumnStatisticsData();
                DoubleColumnStatsData hiveDoubleData = new DoubleColumnStatsData();
                hiveDoubleData.setLowValue(catalogDoubleData.getMinimumValue().doubleValue());
                hiveDoubleData.setHighValue(catalogDoubleData.getMaximumValue().doubleValue());
                hiveDoubleData.setNumDVs(catalogDoubleData.getNumberOfDistinctValues().longValue());
                hiveDoubleData.setNumNulls(catalogDoubleData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setDoubleStats(hiveDoubleData);
                break;
            }
            case LONG: {
                LongColumnStatisticsData catalogLongData = catalogColumnStatisticsData.getLongColumnStatisticsData();
                LongColumnStatsData hiveLongData = new LongColumnStatsData();
                hiveLongData.setLowValue(catalogLongData.getMinimumValue().longValue());
                hiveLongData.setHighValue(catalogLongData.getMaximumValue().longValue());
                hiveLongData.setNumDVs(catalogLongData.getNumberOfDistinctValues().longValue());
                hiveLongData.setNumNulls(catalogLongData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setLongStats(hiveLongData);
                break;
            }
            case STRING: {
                StringColumnStatisticsData catalogStringData = catalogColumnStatisticsData.getStringColumnStatisticsData();
                StringColumnStatsData hiveStringData = new StringColumnStatsData();
                hiveStringData.setAvgColLen(catalogStringData.getAverageLength().doubleValue());
                hiveStringData.setMaxColLen(catalogStringData.getMaximumLength().longValue());
                hiveStringData.setNumDVs(catalogStringData.getNumberOfDistinctValues().longValue());
                hiveStringData.setNumNulls(catalogStringData.getNumberOfNulls().longValue());
                hiveColumnStatisticsData.setStringStats(hiveStringData);
            }
        }
        return hiveColumnStatisticsData;
    }

    private Decimal convertDecimal(DecimalNumber catalogDecimal) {
        Decimal hiveDecimal = new Decimal();
        hiveDecimal.setUnscaled(catalogDecimal.getUnscaledValue());
        hiveDecimal.setScale(catalogDecimal.getScale().shortValue());
        return hiveDecimal;
    }

    static interface HiveException {
        public TException get(String var1);
    }
}

