/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class OkHttpFluxRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpFluxRequestBody.class);
    private final BinaryDataContent content;
    private final long effectiveContentLength;
    private final MediaType mediaType;
    private final AtomicBoolean bodySent = new AtomicBoolean(false);
    private final int callTimeoutMillis;

    public boolean isOneShot() {
        return true;
    }

    public final MediaType contentType() {
        return this.mediaType;
    }

    public final long contentLength() {
        return this.effectiveContentLength;
    }

    public OkHttpFluxRequestBody(BinaryDataContent content, long effectiveContentLength, MediaType mediaType, int callTimeoutMillis) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
        this.effectiveContentLength = effectiveContentLength;
        this.mediaType = mediaType;
        this.callTimeoutMillis = callTimeoutMillis;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (this.bodySent.compareAndSet(false, true)) {
            Mono requestSendMono = this.content.toFluxByteBuffer().flatMapSequential(buffer -> {
                if (Schedulers.isInNonBlockingThread()) {
                    return Mono.just((Object)buffer).publishOn(Schedulers.boundedElastic()).map(b -> OkHttpFluxRequestBody.writeBuffer(bufferedSink, b)).then();
                }
                OkHttpFluxRequestBody.writeBuffer(bufferedSink, buffer);
                return Mono.empty();
            }, 1, 1).then();
            if (this.callTimeoutMillis > 0) {
                requestSendMono.block(Duration.ofMillis(this.callTimeoutMillis));
            } else {
                requestSendMono.block();
            }
        } else {
            throw (IOException)LOGGER.logThrowableAsError((Throwable)new IOException("Re-attempt to send Flux body is not supported"));
        }
    }

    private static ByteBuffer writeBuffer(BufferedSink sink, ByteBuffer buffer) {
        try {
            while (buffer.hasRemaining()) {
                sink.write(buffer);
            }
            return buffer;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

