/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4QAC\u0006\u0001#]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006e\u0001!\te\r\u0005\u0006s\u0001!\tE\u000f\u0005\u0006\u0013\u0002!IA\u0013\u0005\u0007\u001d\u0002!\t!E(\t\u000bA\u0003A\u0011B)\t\u000bQ\u0003A\u0011B+\t\u000ba\u0003A\u0011B-\u00031\u0011\u0013\u0018N^3s\u0007>lW.\u00198e\r\u0016\fG/\u001e:f'R,\u0007O\u0003\u0002\r\u001b\u0005Aa-Z1ukJ,7O\u0003\u0002\u000f\u001f\u0005\u00191\u000eO:\u000b\u0005A\t\u0012A\u00023fa2|\u0017P\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h'\u0011\u0001\u0001D\b\u0012\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\u0002%D\u0001\f\u0013\t\t3BA\u000eLk\n,'O\\3uKN4U-\u0019;ve\u0016\u001cuN\u001c4jON#X\r\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003KE\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003O\u0011\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003W1j\u0011!D\u0005\u0003[5\u0011AcS;cKJtW\r^3t\tJLg/\u001a:D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u00021cA\u0011q\u0004\u0001\u0005\u0006Q\t\u0001\rAK\u0001\rG>tg-[4ve\u0016\u0004v\u000e\u001a\u000b\u0003i]\u0002\"aK\u001b\n\u0005Yj!\u0001C*qCJ\\\u0007k\u001c3\t\u000ba\u001a\u0001\u0019\u0001\u001b\u0002\u0007A|G-\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\u001c)pINK8\u000f^3n!J|\u0007/\u001a:uS\u0016\u001cH#A\u001e\u0011\tq\u001aeI\u0012\b\u0003{\u0005\u0003\"A\u0010\u000e\u000e\u0003}R!\u0001Q\u0015\u0002\rq\u0012xn\u001c;?\u0013\t\u0011%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u00131!T1q\u0015\t\u0011%\u0004\u0005\u0002=\u000f&\u0011\u0001*\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002!\r|gNZ5hkJ,gi\u001c:KCZ\fGc\u0001\u001bL\u0019\")\u0001(\u0002a\u0001i!)Q*\u0002a\u0001\r\u0006\u0019!/Z:\u0002)\u0015tg/\u001b:p]6,g\u000e\u001e,be&\f'\r\\3t+\u0005Y\u0014AE2p]\u001aLw-\u001e:f\r>\u0014\b+\u001f;i_:$2\u0001\u000e*T\u0011\u0015At\u00011\u00015\u0011\u0015iu\u00011\u0001G\u00035\u0019wN\u001c4jOV\u0014XMR8s%R\u0019AGV,\t\u000baB\u0001\u0019\u0001\u001b\t\u000b5C\u0001\u0019\u0001$\u0002'\t\f7/\u001a#sSZ,'oQ8oi\u0006Lg.\u001a:\u0015\u0007iC\u0017\u000e\u0005\u0002\\M6\tAL\u0003\u0002^=\u0006)Qn\u001c3fY*\u0011q\fY\u0001\u0004CBL'BA1c\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003G\u0012\fqAZ1ce&\u001c\u0007HC\u0001f\u0003\tIw.\u0003\u0002h9\n\u00012i\u001c8uC&tWM\u001d\"vS2$WM\u001d\u0005\u0006q%\u0001\r\u0001\u000e\u0005\u0006U&\u0001\rAR\u0001\te\u0016\u001cx.\u001e:dK\u0002")
public class DriverCommandFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesDriverConf conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        MainAppResource mainAppResource = this.conf.mainAppResource();
        if (mainAppResource instanceof JavaMainAppResource) {
            JavaMainAppResource javaMainAppResource = (JavaMainAppResource)mainAppResource;
            Option<String> res = javaMainAppResource.primaryResource();
            return this.configureForJava(pod, (String)res.getOrElse((Function0 & Serializable & scala.Serializable)() -> "spark-internal"));
        }
        if (mainAppResource instanceof PythonMainAppResource) {
            PythonMainAppResource pythonMainAppResource = (PythonMainAppResource)mainAppResource;
            String res = pythonMainAppResource.primaryResource();
            return this.configureForPython(pod, res);
        }
        if (mainAppResource instanceof RMainAppResource) {
            RMainAppResource rMainAppResource = (RMainAppResource)mainAppResource;
            String res = rMainAppResource.primaryResource();
            return this.configureForR(pod, res);
        }
        throw new MatchError((Object)mainAppResource);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String string;
        MainAppResource mainAppResource = this.conf.mainAppResource();
        if (mainAppResource instanceof JavaMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_JAVA();
        } else if (mainAppResource instanceof PythonMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON();
        } else if (mainAppResource instanceof RMainAppResource) {
            string = Constants$.MODULE$.APP_RESOURCE_TYPE_R();
        } else {
            throw new MatchError((Object)mainAppResource);
        }
        String appType = string;
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.APP_RESOURCE_TYPE().key()), (Object)appType)}));
    }

    private SparkPod configureForJava(SparkPod pod, String res) {
        String x$1 = res;
        boolean x$2 = false;
        Option<SparkConf> x$3 = KubernetesUtils$.MODULE$.renameMainAppResource$default$2();
        String newResName = KubernetesUtils$.MODULE$.renameMainAppResource(x$1, x$3, x$2);
        Container driverContainer = this.baseDriverContainer(pod, newResName).build();
        return new SparkPod(pod.pod(), driverContainer);
    }

    public Map<String, String> environmentVariables() {
        return scala.sys.package$.MODULE$.env();
    }

    private SparkPod configureForPython(SparkPod pod, String res) {
        if (((Option)this.conf.get(Config$.MODULE$.PYSPARK_MAJOR_PYTHON_VERSION())).isDefined()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append(Config$.MODULE$.PYSPARK_MAJOR_PYTHON_VERSION().key()).append(" was deprecated in Spark 3.1. ").append("Please set '").append(package$.MODULE$.PYSPARK_PYTHON().key()).append("' and '").append(package$.MODULE$.PYSPARK_DRIVER_PYTHON().key()).append("' ").append("configurations or ").append(Constants$.MODULE$.ENV_PYSPARK_PYTHON()).append(" and ").append(Constants$.MODULE$.ENV_PYSPARK_DRIVER_PYTHON()).append(" environment ").append("variables instead.").toString());
        }
        Seq<EnvVar> pythonEnvs = KubernetesUtils$.MODULE$.buildEnvVars((Seq<Tuple2<String, String>>)((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_PYTHON()), ((Option)this.conf.get(package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> this.environmentVariables().get((Object)Constants$.MODULE$.ENV_PYSPARK_PYTHON())).orNull(Predef$.MODULE$.$conforms())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_DRIVER_PYTHON()), ((Option)this.conf.get(package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)$this.conf.get(package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> this.environmentVariables().get((Object)Constants$.MODULE$.ENV_PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> this.environmentVariables().get((Object)Constants$.MODULE$.ENV_PYSPARK_PYTHON())).orNull(Predef$.MODULE$.$conforms())), (List)Nil$.MODULE$))));
        String newResName = KubernetesUtils$.MODULE$.renameMainAppResource(res, (Option<SparkConf>)Option$.MODULE$.apply((Object)this.conf.sparkConf()), true);
        Container pythonContainer = ((ContainerBuilder)this.baseDriverContainer(pod, newResName).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(pythonEnvs).asJava())).build();
        return new SparkPod(pod.pod(), pythonContainer);
    }

    private SparkPod configureForR(SparkPod pod, String res) {
        Container rContainer = this.baseDriverContainer(pod, res).build();
        return new SparkPod(pod.pod(), rContainer);
    }

    private ContainerBuilder baseDriverContainer(SparkPod pod, String resource) {
        Seq proxyUserArgs = (Seq)Nil$.MODULE$;
        if (!this.conf.proxyUser().isEmpty()) {
            proxyUserArgs = (Seq)proxyUserArgs.$colon$plus((Object)"--proxy-user", Seq$.MODULE$.canBuildFrom());
            proxyUserArgs = (Seq)proxyUserArgs.$colon$plus(this.conf.proxyUser().get(), Seq$.MODULE$.canBuildFrom());
        }
        return (ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).addToArgs(new String[]{"driver"})).addToArgs((String[])proxyUserArgs.toArray(ClassTag$.MODULE$.apply(String.class)))).addToArgs(new String[]{"--properties-file", Constants$.MODULE$.SPARK_CONF_PATH()})).addToArgs(new String[]{"--class", this.conf.mainClass()})).addToArgs(new String[]{resource})).addToArgs(this.conf.appArgs());
    }

    public DriverCommandFeatureStep(KubernetesDriverConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
    }
}

