/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.planning;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceData;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;

public final class GroupBasedRowLevelOperation$ {
    public static GroupBasedRowLevelOperation$ MODULE$;

    static {
        new GroupBasedRowLevelOperation$();
    }

    public Option<Tuple4<ReplaceData, Expression, Option<Expression>, LogicalPlan>> unapply(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof ReplaceData) {
            ReplaceData replaceData = (ReplaceData)logicalPlan;
            NamedRelation namedRelation = replaceData.table();
            Expression cond = replaceData.condition();
            LogicalPlan query = replaceData.query();
            Option<Expression> groupFilterCond = replaceData.groupFilterCondition();
            if (namedRelation instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)namedRelation;
                Table table = dataSourceV2Relation.table();
                RowLevelOperation.Command command = replaceData.operation().command();
                RowLevelOperation.Command command2 = RowLevelOperation.Command.UPDATE;
                boolean allowMultipleReads = !(command != null ? !((Object)((Object)command)).equals((Object)command2) : command2 != null);
                Option<LogicalPlan> readRelation = this.findReadRelation(table, query, allowMultipleReads);
                return readRelation.map((Function1 & java.io.Serializable & Serializable)x$18 -> new Tuple4((Object)replaceData, (Object)cond, (Object)groupFilterCond, x$18));
            }
        }
        return None$.MODULE$;
    }

    private Option<LogicalPlan> findReadRelation(Table table, LogicalPlan plan2, boolean allowMultipleReads) {
        Some some;
        Seq readRelations = plan2.collect(new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final Table table$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)A1).table() == this.table$1) {
                    return (B1)dataSourceV2Relation;
                }
                if (A1 instanceof DataSourceV2ScanRelation && (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1).relation().table() == this.table$1) {
                    return (B1)dataSourceV2ScanRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).table() == this.table$1) {
                    return true;
                }
                return logicalPlan instanceof DataSourceV2ScanRelation && (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan).relation().table() == this.table$1;
            }
            {
                this.table$1 = table$1;
            }
        });
        Seq seq = readRelations;
        if (seq.isEmpty()) {
            return None$.MODULE$;
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
            LeafNode relation = (LeafNode)((SeqLike)some2.get()).apply(0);
            return new Some((Object)relation);
        }
        Some some3 = Seq$.MODULE$.unapplySeq(seq);
        if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
            LeafNode relation1 = (LeafNode)((SeqLike)some3.get()).apply(0);
            LeafNode relation2 = (LeafNode)((SeqLike)some3.get()).apply(1);
            if (relation1 instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)relation1;
                if (relation2 instanceof DataSourceV2Relation) {
                    DataSourceV2Relation dataSourceV2Relation2 = (DataSourceV2Relation)relation2;
                    if (allowMultipleReads && dataSourceV2Relation.table() == dataSourceV2Relation2.table()) {
                        return new Some((Object)dataSourceV2Relation);
                    }
                }
            }
        }
        if (!(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            LeafNode relation1 = (LeafNode)((SeqLike)some.get()).apply(0);
            LeafNode relation2 = (LeafNode)((SeqLike)some.get()).apply(1);
            if (relation1 instanceof DataSourceV2ScanRelation) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)relation1;
                if (relation2 instanceof DataSourceV2ScanRelation) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation2 = (DataSourceV2ScanRelation)relation2;
                    if (allowMultipleReads && dataSourceV2ScanRelation.scan() == dataSourceV2ScanRelation2.scan()) {
                        return new Some((Object)dataSourceV2ScanRelation);
                    }
                }
            }
        }
        throw new AnalysisException(new StringBuilder(57).append("Unexpected row-level read relations (allow multiple = ").append(allowMultipleReads).append("): ").append(seq).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private GroupBasedRowLevelOperation$() {
        MODULE$ = this;
    }
}

