/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Joiner;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Grpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.Matchers;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AlwaysTrueMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AndMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AuthConfig;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AuthDecision;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AuthHeaderMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_AuthenticatedMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_DestinationIpMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_DestinationPortMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_DestinationPortRangeMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_InvertMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_OrMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_PathMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_PolicyMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_RequestedServerNameMatcher;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.rbac.engine.AutoValue_GrpcAuthorizationEngine_SourceIpMatcher;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class GrpcAuthorizationEngine {
    private static final Logger log = Logger.getLogger(GrpcAuthorizationEngine.class.getName());
    private final AuthConfig authConfig;

    public GrpcAuthorizationEngine(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public AuthDecision evaluate(Metadata metadata, ServerCall<?, ?> serverCall) {
        Preconditions.checkNotNull(metadata, "metadata");
        Preconditions.checkNotNull(serverCall, "serverCall");
        String firstMatch = null;
        EvaluateArgs args = new EvaluateArgs(metadata, serverCall);
        for (PolicyMatcher policyMatcher : this.authConfig.policies()) {
            if (!policyMatcher.matches(args)) continue;
            firstMatch = policyMatcher.name();
            break;
        }
        Action decisionType = Action.DENY;
        if (Action.DENY.equals((Object)this.authConfig.action()) == (firstMatch == null)) {
            decisionType = Action.ALLOW;
        }
        return AuthDecision.create(decisionType, firstMatch);
    }

    @AutoValue
    public static abstract class InvertMatcher
    implements Matcher {
        public abstract Matcher toInvertMatcher();

        public static InvertMatcher create(Matcher matcher) {
            return new AutoValue_GrpcAuthorizationEngine_InvertMatcher(matcher);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return !this.toInvertMatcher().matches(args);
        }
    }

    @AutoValue
    public static abstract class AlwaysTrueMatcher
    implements Matcher {
        public static AlwaysTrueMatcher INSTANCE = new AutoValue_GrpcAuthorizationEngine_AlwaysTrueMatcher();

        @Override
        public boolean matches(EvaluateArgs args) {
            return true;
        }
    }

    @AutoValue
    public static abstract class AndMatcher
    implements Matcher {
        public abstract ImmutableList<? extends Matcher> allMatch();

        public static AndMatcher create(List<? extends Matcher> matchers) {
            Preconditions.checkNotNull(matchers, "matchers");
            for (Matcher matcher : matchers) {
                Preconditions.checkNotNull(matcher, "matcher");
            }
            return new AutoValue_GrpcAuthorizationEngine_AndMatcher(ImmutableList.copyOf(matchers));
        }

        public static AndMatcher create(Matcher ... matchers) {
            return AndMatcher.create(Arrays.asList(matchers));
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            for (Matcher matcher : this.allMatch()) {
                if (matcher.matches(args)) continue;
                return false;
            }
            return true;
        }
    }

    @AutoValue
    public static abstract class OrMatcher
    implements Matcher {
        public abstract ImmutableList<? extends Matcher> anyMatch();

        public static OrMatcher create(List<? extends Matcher> matchers) {
            Preconditions.checkNotNull(matchers, "matchers");
            for (Matcher matcher : matchers) {
                Preconditions.checkNotNull(matcher, "matcher");
            }
            return new AutoValue_GrpcAuthorizationEngine_OrMatcher(ImmutableList.copyOf(matchers));
        }

        public static OrMatcher create(Matcher ... matchers) {
            return OrMatcher.create(Arrays.asList(matchers));
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            for (Matcher matcher : this.anyMatch()) {
                if (!matcher.matches(args)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Matcher {
        public boolean matches(EvaluateArgs var1);
    }

    private static final class EvaluateArgs {
        private final Metadata metadata;
        private final ServerCall<?, ?> serverCall;
        private static final int URI_SAN = 6;
        private static final int DNS_SAN = 2;

        private EvaluateArgs(Metadata metadata, ServerCall<?, ?> serverCall) {
            this.metadata = metadata;
            this.serverCall = serverCall;
        }

        private String getPath() {
            return "/" + this.serverCall.getMethodDescriptor().getFullMethodName();
        }

        @Nullable
        private Collection<String> getPrincipalNames() {
            SSLSession sslSession = this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
            if (sslSession == null) {
                return null;
            }
            try {
                Certificate[] certs = sslSession.getPeerCertificates();
                if (certs == null || certs.length < 1) {
                    return Collections.singleton("");
                }
                X509Certificate cert = (X509Certificate)certs[0];
                if (cert == null) {
                    return Collections.singleton("");
                }
                Collection<List<?>> names = cert.getSubjectAlternativeNames();
                ArrayList<String> principalNames = new ArrayList<String>();
                if (names != null) {
                    for (List<?> name : names) {
                        if (6 != (Integer)name.get(0)) continue;
                        principalNames.add((String)name.get(1));
                    }
                    if (!principalNames.isEmpty()) {
                        return Collections.unmodifiableCollection(principalNames);
                    }
                    for (List<?> name : names) {
                        if (2 != (Integer)name.get(0)) continue;
                        principalNames.add((String)name.get(1));
                    }
                    if (!principalNames.isEmpty()) {
                        return Collections.unmodifiableCollection(principalNames);
                    }
                }
                if (cert.getSubjectX500Principal() == null || cert.getSubjectX500Principal().getName() == null) {
                    return Collections.singleton("");
                }
                return Collections.singleton(cert.getSubjectX500Principal().getName());
            }
            catch (CertificateParsingException | SSLPeerUnverifiedException ex) {
                log.log(Level.FINE, "Unexpected getPrincipalNames error.", ex);
                return Collections.singleton("");
            }
        }

        @Nullable
        private String getHeader(String headerName) {
            if ("te".equals(headerName = headerName.toLowerCase(Locale.ROOT))) {
                return null;
            }
            if (":authority".equals(headerName)) {
                headerName = "host";
            }
            if ("host".equals(headerName)) {
                return this.serverCall.getAuthority();
            }
            if (":path".equals(headerName)) {
                return this.getPath();
            }
            if (":method".equals(headerName)) {
                return "POST";
            }
            return this.deserializeHeader(headerName);
        }

        @Nullable
        private String deserializeHeader(String headerName) {
            Metadata.Key<String> key;
            if (headerName.endsWith("-bin")) {
                Metadata.Key<byte[]> key2;
                try {
                    key2 = Metadata.Key.of(headerName, Metadata.BINARY_BYTE_MARSHALLER);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                Iterable<byte[]> values = this.metadata.getAll(key2);
                if (values == null) {
                    return null;
                }
                ArrayList<String> encoded = new ArrayList<String>();
                for (byte[] v : values) {
                    encoded.add(BaseEncoding.base64().omitPadding().encode(v));
                }
                return Joiner.on(",").join(encoded);
            }
            try {
                key = Metadata.Key.of(headerName, Metadata.ASCII_STRING_MARSHALLER);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            Iterable<String> values = this.metadata.getAll(key);
            return values == null ? null : Joiner.on(",").join(values);
        }

        private InetAddress getDestinationIp() {
            SocketAddress addr = this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
            return addr == null ? null : ((InetSocketAddress)addr).getAddress();
        }

        private InetAddress getSourceIp() {
            SocketAddress addr = this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            return addr == null ? null : ((InetSocketAddress)addr).getAddress();
        }

        private int getDestinationPort() {
            SocketAddress addr = this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
            return addr == null ? -1 : ((InetSocketAddress)addr).getPort();
        }

        private String getRequestedServerName() {
            return "";
        }
    }

    @AutoValue
    public static abstract class RequestedServerNameMatcher
    implements Matcher {
        public abstract Matchers.StringMatcher delegate();

        public static RequestedServerNameMatcher create(Matchers.StringMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_RequestedServerNameMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate().matches(args.getRequestedServerName());
        }
    }

    @AutoValue
    public static abstract class DestinationPortRangeMatcher
    implements Matcher {
        public abstract int start();

        public abstract int end();

        public static DestinationPortRangeMatcher create(int start, int end) {
            return new AutoValue_GrpcAuthorizationEngine_DestinationPortRangeMatcher(start, end);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            int port = args.getDestinationPort();
            return port >= this.start() && port < this.end();
        }
    }

    @AutoValue
    public static abstract class DestinationPortMatcher
    implements Matcher {
        public abstract int port();

        public static DestinationPortMatcher create(int port) {
            return new AutoValue_GrpcAuthorizationEngine_DestinationPortMatcher(port);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.port() == args.getDestinationPort();
        }
    }

    @AutoValue
    public static abstract class AuthHeaderMatcher
    implements Matcher {
        public abstract Matchers.HeaderMatcher delegate();

        public static AuthHeaderMatcher create(Matchers.HeaderMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_AuthHeaderMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate().matches(args.getHeader(this.delegate().name()));
        }
    }

    @AutoValue
    public static abstract class PathMatcher
    implements Matcher {
        public abstract Matchers.StringMatcher delegate();

        public static PathMatcher create(Matchers.StringMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_PathMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate().matches(args.getPath());
        }
    }

    @AutoValue
    public static abstract class SourceIpMatcher
    implements Matcher {
        public abstract Matchers.CidrMatcher delegate();

        public static SourceIpMatcher create(Matchers.CidrMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_SourceIpMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate().matches(args.getSourceIp());
        }
    }

    @AutoValue
    public static abstract class DestinationIpMatcher
    implements Matcher {
        public abstract Matchers.CidrMatcher delegate();

        public static DestinationIpMatcher create(Matchers.CidrMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_DestinationIpMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.delegate().matches(args.getDestinationIp());
        }
    }

    @AutoValue
    public static abstract class AuthenticatedMatcher
    implements Matcher {
        @Nullable
        public abstract Matchers.StringMatcher delegate();

        public static AuthenticatedMatcher create(@Nullable Matchers.StringMatcher delegate) {
            return new AutoValue_GrpcAuthorizationEngine_AuthenticatedMatcher(delegate);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            Collection principalNames = args.getPrincipalNames();
            log.log(Level.FINER, "Matching principal names: {0}", new Object[]{principalNames});
            if (principalNames == null) {
                return false;
            }
            if (this.delegate() == null) {
                return true;
            }
            for (String name : principalNames) {
                if (!this.delegate().matches(name)) continue;
                return true;
            }
            return false;
        }
    }

    @AutoValue
    public static abstract class PolicyMatcher
    implements Matcher {
        public abstract String name();

        public abstract OrMatcher permissions();

        public abstract OrMatcher principals();

        public static PolicyMatcher create(String name, OrMatcher permissions, OrMatcher principals) {
            return new AutoValue_GrpcAuthorizationEngine_PolicyMatcher(name, permissions, principals);
        }

        @Override
        public boolean matches(EvaluateArgs args) {
            return this.permissions().matches(args) && this.principals().matches(args);
        }
    }

    @AutoValue
    public static abstract class AuthConfig {
        public abstract ImmutableList<PolicyMatcher> policies();

        public abstract Action action();

        public static AuthConfig create(List<PolicyMatcher> policies, Action action) {
            return new AutoValue_GrpcAuthorizationEngine_AuthConfig(ImmutableList.copyOf(policies), action);
        }
    }

    @AutoValue
    public static abstract class AuthDecision {
        public abstract Action decision();

        @Nullable
        public abstract String matchingPolicyName();

        static AuthDecision create(Action decisionType, @Nullable String matchingPolicy) {
            return new AutoValue_GrpcAuthorizationEngine_AuthDecision(decisionType, matchingPolicy);
        }
    }

    public static enum Action {
        ALLOW,
        DENY;

    }
}

