/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.TimeProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider.CertificateProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.trust.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FileWatcherCertificateProvider
extends CertificateProvider
implements Runnable {
    private static final Logger logger = Logger.getLogger(FileWatcherCertificateProvider.class.getName());
    private final ScheduledExecutorService scheduledExecutorService;
    private final TimeProvider timeProvider;
    private final Path certFile;
    private final Path keyFile;
    private final Path trustFile;
    private final long refreshIntervalInSeconds;
    @VisibleForTesting
    ScheduledFuture<?> scheduledFuture;
    private FileTime lastModifiedTimeCert;
    private FileTime lastModifiedTimeKey;
    private FileTime lastModifiedTimeRoot;
    private boolean shutdown;

    FileWatcherCertificateProvider(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
        super(watcher, notifyCertUpdates);
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        this.timeProvider = Preconditions.checkNotNull(timeProvider, "timeProvider");
        this.certFile = Paths.get(Preconditions.checkNotNull(certFile, "certFile"), new String[0]);
        this.keyFile = Paths.get(Preconditions.checkNotNull(keyFile, "keyFile"), new String[0]);
        this.trustFile = Paths.get(Preconditions.checkNotNull(trustFile, "trustFile"), new String[0]);
        this.refreshIntervalInSeconds = refreshIntervalInSeconds;
    }

    @Override
    public void start() {
        this.scheduleNextRefreshCertificate(0L);
    }

    @Override
    public synchronized void close() {
        this.shutdown = true;
        this.scheduledExecutorService.shutdownNow();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.getWatcher().close();
    }

    private synchronized void scheduleNextRefreshCertificate(long delayInSeconds) {
        if (!this.shutdown) {
            this.scheduledFuture = this.scheduledExecutorService.schedule(this, delayInSeconds, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    void checkAndReloadCertificates() {
        try {
            byte[] rootFileContents;
            FileTime currentRootTime;
            block31: {
                block30: {
                    block33: {
                        FileTime currentCertTime = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (currentCertTime.equals(this.lastModifiedTimeCert) || currentKeyTime.equals(this.lastModifiedTimeKey)) break block33;
                        byte[] certFileContents = Files.readAllBytes(this.certFile);
                        byte[] keyFileContents = Files.readAllBytes(this.keyFile);
                        FileTime currentCertTime2 = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime2 = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (!currentCertTime2.equals(currentCertTime)) {
                            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                            return;
                        }
                        if (!currentKeyTime2.equals(currentKeyTime)) {
                            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                            return;
                        }
                        try {
                            try (ByteArrayInputStream certStream = new ByteArrayInputStream(certFileContents);
                                 ByteArrayInputStream keyStream = new ByteArrayInputStream(keyFileContents);){
                                PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStream);
                                X509Certificate[] certs = CertificateUtils.toX509Certificates(certStream);
                                this.getWatcher().updateCertificate(privateKey, Arrays.asList(certs));
                            }
                            this.lastModifiedTimeCert = currentCertTime;
                            this.lastModifiedTimeKey = currentKeyTime;
                        }
                        catch (Throwable t) {
                            this.generateErrorIfCurrentCertExpired(t);
                        }
                    }
                    currentRootTime = Files.getLastModifiedTime(this.trustFile, new LinkOption[0]);
                    if (!currentRootTime.equals(this.lastModifiedTimeRoot)) break block30;
                    this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                    return;
                    {
                        catch (Throwable t) {
                            this.getWatcher().onError(Status.fromThrowable(t));
                            return;
                        }
                    }
                }
                rootFileContents = Files.readAllBytes(this.trustFile);
                FileTime currentRootTime2 = Files.getLastModifiedTime(this.trustFile, new LinkOption[0]);
                if (currentRootTime2.equals(currentRootTime)) break block31;
                this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                return;
            }
            try (ByteArrayInputStream rootStream = new ByteArrayInputStream(rootFileContents);){
                X509Certificate[] caCerts = CertificateUtils.toX509Certificates(rootStream);
                this.getWatcher().updateTrustedRoots(Arrays.asList(caCerts));
            }
            this.lastModifiedTimeRoot = currentRootTime;
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
        }
    }

    private void generateErrorIfCurrentCertExpired(Throwable t) {
        X509Certificate currentCert = this.getWatcher().getLastIdentityCert();
        if (currentCert != null) {
            long delaySeconds = this.computeDelaySecondsToCertExpiry(currentCert);
            if (delaySeconds > this.refreshIntervalInSeconds) {
                logger.log(Level.FINER, "reload certificate error", t);
                return;
            }
            this.getWatcher().clearValues();
        }
        this.getWatcher().onError(Status.fromThrowable(t));
    }

    private long computeDelaySecondsToCertExpiry(X509Certificate lastCert) {
        Preconditions.checkNotNull(lastCert, "lastCert");
        return TimeUnit.NANOSECONDS.toSeconds(TimeUnit.MILLISECONDS.toNanos(lastCert.getNotAfter().getTime()) - this.timeProvider.currentTimeNanos());
    }

    @Override
    public void run() {
        block3: {
            if (!this.shutdown) {
                try {
                    this.checkAndReloadCertificates();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Uncaught exception!", t);
                    if (!(t instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
                return new FileWatcherCertificateProvider(watcher, notifyCertUpdates, certFile, keyFile, trustFile, refreshIntervalInSeconds, scheduledExecutorService, timeProvider);
            }
        };

        Factory() {
        }

        static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher var1, boolean var2, String var3, String var4, String var5, long var6, ScheduledExecutorService var8, TimeProvider var9);
    }
}

