/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics;

import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.internal.Utils;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.LabelKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.LabelValue;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DoubleCumulative {
    public abstract DoublePoint getOrCreateTimeSeries(List<LabelValue> var1);

    public abstract DoublePoint getDefaultTimeSeries();

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DoubleCumulative newNoopDoubleCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDoubleCumulative.create(name, description, unit, labelKeys);
    }

    private static final class NoopDoubleCumulative
    extends DoubleCumulative {
        private final int labelKeysSize;

        static NoopDoubleCumulative create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDoubleCumulative(name, description, unit, labelKeys);
        }

        NoopDoubleCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public NoopDoublePoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopDoublePoint.INSTANCE;
        }

        @Override
        public NoopDoublePoint getDefaultTimeSeries() {
            return NoopDoublePoint.INSTANCE;
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }

        private static final class NoopDoublePoint
        extends DoublePoint {
            private static final NoopDoublePoint INSTANCE = new NoopDoublePoint();

            private NoopDoublePoint() {
            }

            @Override
            public void add(double delta) {
            }
        }
    }

    public static abstract class DoublePoint {
        public abstract void add(double var1);
    }
}

