/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.commands.DeletionVectorBitmapGenerator;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.FileToDvDescriptor;
import org.apache.spark.sql.delta.commands.FileToDvDescriptor$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeletionVectorBitmapGenerator$ {
    public static DeletionVectorBitmapGenerator$ MODULE$;

    static {
        new DeletionVectorBitmapGenerator$();
    }

    public final String FILE_NAME_COL() {
        return "filePath";
    }

    public final String FILE_DV_ID_COL() {
        return "deletionVectorId";
    }

    public final String ROW_INDEX_COL() {
        return "rowIndexCol";
    }

    public final String DELETED_ROW_INDEX_BITMAP() {
        return "deletedRowIndexSet";
    }

    public final String DELETED_ROW_INDEX_COUNT() {
        return "deletedRowIndexCount";
    }

    public final String MAX_ROW_INDEX_COL() {
        return "maxRowIndexCol";
    }

    public Seq<DeletionVectorResult> buildDeletionVectors(SparkSession spark, Dataset<Row> target, DeltaLog targetDeltaLog, OptimisticTransaction deltaTxn) {
        DeletionVectorBitmapGenerator.DeletionVectorSet rowIndexSet = new DeletionVectorBitmapGenerator.DeletionVectorSet(spark, target, targetDeltaLog, deltaTxn);
        return rowIndexSet.computeResult();
    }

    public Seq<DeletionVectorResult> buildRowIndexSetsForFilesMatchingCondition(SparkSession sparkSession, OptimisticTransaction txn, boolean tableHasDVs, Dataset<Row> targetDf, Seq<AddFile> candidateFiles, Expression condition, Option<Column> fileNameColumnOpt, Option<Column> rowIndexColumnOpt) {
        Dataset dataset;
        ConfigEntry<Object> useMetadataRowIndexConf = DeltaSQLConf$.MODULE$.DELETION_VECTORS_USE_METADATA_ROW_INDEX();
        boolean useMetadataRowIndex = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(useMetadataRowIndexConf));
        Column fileNameColumn = (Column)fileNameColumnOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col(new StringBuilder(1).append(FileFormat$.MODULE$.METADATA_NAME()).append(".").append(FileFormat$.MODULE$.FILE_PATH()).toString()));
        Column rowIndexColumn = useMetadataRowIndex ? (Column)rowIndexColumnOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col(new StringBuilder(1).append(FileFormat$.MODULE$.METADATA_NAME()).append(".").append(ParquetFileFormat$.MODULE$.ROW_INDEX()).toString())) : (Column)rowIndexColumnOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> functions$.MODULE$.col(DeltaParquetFileFormat$.MODULE$.ROW_INDEX_COLUMN_NAME()));
        Dataset matchedRowsDf = targetDf.withColumn("filePath", fileNameColumn).filter(new Column(condition)).withColumn("rowIndexCol", rowIndexColumn);
        if (tableHasDVs) {
            Dataset joinedDf;
            String basePath = txn.deltaLog().dataPath().toString();
            Seq filePathToDV = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)add -> {
                Option serializedDV = Option$.MODULE$.apply((Object)add.deletionVector()).map((Function1 & Serializable & scala.Serializable)dvd -> JsonUtils$.MODULE$.toJson(dvd, ManifestFactory$.MODULE$.classType(DeletionVectorDescriptor.class)));
                return new FileToDvDescriptor(SparkPath$.MODULE$.fromPath(DeltaFileOperations$.MODULE$.absolutePath(basePath, add.path())).urlEncoded(), (Option<String>)serializedDV);
            }, Seq$.MODULE$.canBuildFrom());
            Dataset filePathToDVDf = sparkSession.createDataset(filePathToDV, FileToDvDescriptor$.MODULE$.encoder());
            Column joinExpr = filePathToDVDf.apply("path").$eq$eq$eq((Object)matchedRowsDf.apply("filePath"));
            dataset = joinedDf = matchedRowsDf.join(filePathToDVDf, joinExpr, "leftOuter").drop("filePath").withColumnRenamed("path", "filePath");
        } else {
            dataset = matchedRowsDf.withColumn("deletionVectorId", functions$.MODULE$.lit(null));
        }
        Dataset df = dataset;
        return this.buildDeletionVectors(sparkSession, (Dataset<Row>)df, txn.deltaLog(), txn);
    }

    public Option<Column> buildRowIndexSetsForFilesMatchingCondition$default$7() {
        return None$.MODULE$;
    }

    public Option<Column> buildRowIndexSetsForFilesMatchingCondition$default$8() {
        return None$.MODULE$;
    }

    private DeletionVectorBitmapGenerator$() {
        MODULE$ = this;
    }
}

