/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.commands.convert.ConvertUtils$;
import org.apache.spark.sql.delta.commands.convert.ParquetSchemaFetchConfig;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A\u0001D\u0007\u00019!Aa\u0003\u0001B\u0001B\u0003%q\u0006\u0003\u00054\u0001\t\u0015\r\u0011\"\u00115\u0011!\u0011\u0005A!A!\u0002\u0013)\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\u0006;\u0002!\tB\u0018\u0005\tM\u0002A)\u0019!C!O\"AA\u000e\u0001EC\u0002\u0013\u0005S\u000eC\u0003s\u0001\u0011\u00053OA\rNC:,\u0018\r\u001c'jgRLgn\u001a$jY\u0016l\u0015M\\5gKN$(B\u0001\b\u0010\u0003\u001d\u0019wN\u001c<feRT!\u0001E\t\u0002\u0011\r|W.\\1oINT!AE\n\u0002\u000b\u0011,G\u000e^1\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001iR%\u000b\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0011aeJ\u0007\u0002\u001b%\u0011\u0001&\u0004\u0002\u001a\u0007>tg/\u001a:u)\u0006\u0014x-\u001a;GS2,W*\u00198jM\u0016\u001cH\u000f\u0005\u0002+[5\t1F\u0003\u0002-#\u0005AQ.\u001a;fe&tw-\u0003\u0002/W\taA)\u001a7uC2{wmZ5oOB\u0011\u0001'M\u0007\u0002'%\u0011!g\u0005\u0002\r'B\f'o[*fgNLwN\\\u0001\tE\u0006\u001cX\rU1uQV\tQ\u0007\u0005\u00027\u007f9\u0011q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0003um\ta\u0001\u0010:p_Rt$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ\u0014A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\u001e\u0002\u0013\t\f7/\u001a)bi\"\u0004\u0013a\u00049beRLG/[8o'\u000eDW-\\1\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u001b\u0012!\u0002;za\u0016\u001c\u0018BA%G\u0005)\u0019FO];diRK\b/Z\u0001\u0019a\u0006\u0014\u0018/^3u'\u000eDW-\\1GKR\u001c\u0007nQ8oM&<\u0007C\u0001\u0014M\u0013\tiUB\u0001\rQCJ\fX/\u001a;TG\",W.\u0019$fi\u000eD7i\u001c8gS\u001e\f\u0001c]3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4\u0011\u0005A\u001bV\"A)\u000b\u0005I+\u0012\u0001B;uS2L!\u0001V)\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r]C\u0016LW.]!\t1\u0003\u0001C\u0003\u0017\u000f\u0001\u0007q\u0006C\u00034\u000f\u0001\u0007Q\u0007C\u0003D\u000f\u0001\u0007A\tC\u0003K\u000f\u0001\u00071\nC\u0003O\u000f\u0001\u0007q*\u0001\u0004e_2K7\u000f\u001e\u000b\u0002?B\u0019\u0001\u0007\u00192\n\u0005\u0005\u001c\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0003G\u0012l\u0011!E\u0005\u0003KF\u0011acU3sS\u0006d\u0017N_1cY\u00164\u0015\u000e\\3Ti\u0006$Xo]\u0001\tC2dg)\u001b7fgV\t\u0001\u000eE\u00021A&\u0004\"A\n6\n\u0005-l!!E\"p]Z,'\u000f\u001e+be\u001e,GOR5mK\u0006i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006,\u0012A\u001c\t\u0004_B$U\"A\u001e\n\u0005E\\$AB(qi&|g.A\u0003dY>\u001cX\rF\u0001u!\tyW/\u0003\u0002ww\t!QK\\5u\u0001")
public class ManualListingFileManifest
implements ConvertTargetFileManifest,
DeltaLogging {
    private Dataset<ConvertTargetFile> allFiles;
    private Option<StructType> parquetSchema;
    private final SparkSession spark;
    private final String basePath;
    private final StructType partitionSchema;
    private final ParquetSchemaFetchConfig parquetSchemaFetchConfig;
    private final SerializableConfiguration serializableConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Iterator<ConvertTargetFile> getFiles() {
        return ConvertTargetFileManifest.getFiles$(this);
    }

    @Override
    public long numFiles() {
        return ConvertTargetFileManifest.numFiles$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    public Dataset<SerializableFileStatus> doList() {
        Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return DeltaFileOperations$.MODULE$.recursiveListDirs(this.spark, (Seq<String>)((Seq)new .colon.colon((Object)this.basePath(), (List)Nil$.MODULE$)), (Broadcast<SerializableConfiguration>)conf, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)dirName -> BoxesRunTime.boxToBoolean((boolean)ConvertUtils$.MODULE$.dirNameFilter(dirName)), DeltaFileOperations$.MODULE$.recursiveListDirs$default$5(), DeltaFileOperations$.MODULE$.recursiveListDirs$default$6(), DeltaFileOperations$.MODULE$.recursiveListDirs$default$7()).where("!isDir");
    }

    private Dataset<ConvertTargetFile> allFiles$lzycompute() {
        ManualListingFileManifest manualListingFileManifest = this;
        synchronized (manualListingFileManifest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                ParquetSchemaFetchConfig fetchConfig = this.parquetSchemaFetchConfig;
                Dataset files = this.doList().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                    Seq fileStatuses = iter.toSeq();
                    Map pathToStatusMapping = ((TraversableOnce)fileStatuses.map((Function1 & Serializable & scala.Serializable)fileStatus -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fileStatus.path()), fileStatus), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Seq<Footer> footerSeq = DeltaFileOperations$.MODULE$.readParquetFootersInParallel(((SerializableConfiguration)conf.value()).value(), (Seq<FileStatus>)((Seq)fileStatuses.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toFileStatus(), Seq$.MODULE$.canBuildFrom())), fetchConfig.ignoreCorruptFiles());
                    ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(fetchConfig.assumeBinaryIsString(), fetchConfig.assumeInt96IsTimestamp(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5());
                    return ((IterableLike)footerSeq.map((Function1 & Serializable & scala.Serializable)footer -> {
                        SerializableFileStatus fileStatus = (SerializableFileStatus)pathToStatusMapping.apply((Object)footer.getFile().toString());
                        StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, schemaConverter);
                        return new ConvertTargetFile(fileStatus, (Option<Map<String, String>>)None$.MODULE$, (Option<String>)new Some((Object)schema.toDDL()));
                    }, Seq$.MODULE$.canBuildFrom())).toIterator();
                }, package$.MODULE$.convertTargetFileEncoder());
                files.cache();
                this.allFiles = files;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allFiles;
    }

    @Override
    public Dataset<ConvertTargetFile> allFiles() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.allFiles$lzycompute();
        }
        return this.allFiles;
    }

    private Option<StructType> parquetSchema$lzycompute() {
        ManualListingFileManifest manualListingFileManifest = this;
        synchronized (manualListingFileManifest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.parquetSchema = (Option)this.recordDeltaOperationForTablePath(this.basePath(), "delta.convert.schemaInference", this.recordDeltaOperationForTablePath$default$3(), (Function0 & Serializable & scala.Serializable)() -> new Some((Object)ConvertUtils$.MODULE$.mergeSchemasInParallel($this.spark, $this.partitionSchema, this.allFiles())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.parquetSchema;
    }

    @Override
    public Option<StructType> parquetSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.parquetSchema$lzycompute();
        }
        return this.parquetSchema;
    }

    @Override
    public void close() {
        this.allFiles().unpersist();
    }

    public ManualListingFileManifest(SparkSession spark, String basePath, StructType partitionSchema, ParquetSchemaFetchConfig parquetSchemaFetchConfig, SerializableConfiguration serializableConf) {
        this.spark = spark;
        this.basePath = basePath;
        this.partitionSchema = partitionSchema;
        this.parquetSchemaFetchConfig = parquetSchemaFetchConfig;
        this.serializableConf = serializableConf;
        ConvertTargetFileManifest.$init$(this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

