/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONJAXBContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONMarshaller;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public final class YarnWebServiceUtils {
    private YarnWebServiceUtils() {
    }

    public static JSONObject getNodeInfoFromRMWebService(Configuration conf, String nodeId) throws ClientHandlerException, UniformInterfaceException {
        try {
            return WebAppUtils.execOnActiveRM(conf, YarnWebServiceUtils::getNodeInfoFromRM, nodeId);
        }
        catch (Exception e) {
            if (e instanceof ClientHandlerException) {
                throw (ClientHandlerException)((Object)e);
            }
            if (e instanceof UniformInterfaceException) {
                throw (UniformInterfaceException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getNodeInfoFromRM(String webAppAddress, String nodeId) throws ClientHandlerException, UniformInterfaceException {
        Client webServiceClient = Client.create();
        ClientResponse response = null;
        try {
            WebResource.Builder builder = webServiceClient.resource(webAppAddress).path("ws").path("v1").path("cluster").path("nodes").path(nodeId).accept(new String[]{"application/json"});
            response = (ClientResponse)builder.get(ClientResponse.class);
            JSONObject jSONObject = (JSONObject)response.getEntity(JSONObject.class);
            return jSONObject;
        }
        finally {
            if (response != null) {
                response.close();
            }
            webServiceClient.destroy();
        }
    }

    public static String toJson(Object nsli, Class klass) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON(nsli, (Writer)sw);
        return sw.toString();
    }
}

