/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool$CachedFetchedData$;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rf!B A\u0001\u0001c\u0005\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006a\u0002!\ta\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\u0011\u0019\u0004\u0001Q\u0001\nqD\u0011B!\u000e\u0001\u0005\u0004%I!a\u001a\t\u0011\t]\u0002\u0001)A\u0005\u0003SB\u0011B!\u000f\u0001\u0005\u0004%I!a\u001a\t\u0011\tm\u0002\u0001)A\u0005\u0003SBqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0005\u0003\\\u0001\u0001\r\u0011\"\u0003\u0003^!I!q\f\u0001A\u0002\u0013%!\u0011\r\u0005\t\u0005K\u0002\u0001\u0015)\u0003\u0003B!I!q\r\u0001C\u0002\u0013%!\u0011\u000e\u0005\t\u0005o\u0002\u0001\u0015!\u0003\u0003l!I!\u0011\u0010\u0001C\u0002\u0013%!\u0011\u000e\u0005\t\u0005w\u0002\u0001\u0015!\u0003\u0003l!9!Q\u0010\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B@\u0001\u0011\u0005\u0011q\r\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fCqAa%\u0001\t\u0003\u0011)\nC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t}\u0005\u0001\"\u0001\u0003\u001e\"9!\u0011\u0015\u0001\u0005\n\tuu\u0001CA\u001d\u0001\"\u0005\u0001)a\u000f\u0007\u000f}\u0002\u0005\u0012\u0001!\u0002>!1\u0001/\bC\u0001\u0003\u007f1q!!\u0011\u001e\u0001\u0002\u000b\u0019\u0005\u0003\u0006\u0002R}\u0011)\u001a!C\u0001\u0003'B!\"a\u0017 \u0005#\u0005\u000b\u0011BA+\u0011\u0019\u0001x\u0004\"\u0001\u0002^!I\u0011QM\u0010A\u0002\u0013\u0005\u0011q\r\u0005\n\u0003_z\u0002\u0019!C\u0001\u0003cB\u0001\"!  A\u0003&\u0011\u0011\u000e\u0005\n\u0003\u007fz\u0002\u0019!C\u0001\u0003OB\u0011\"!! \u0001\u0004%\t!a!\t\u0011\u0005\u001du\u0004)Q\u0005\u0003SB\u0011\"!# \u0001\u0004%\t!a#\t\u0013\u0005Mu\u00041A\u0005\u0002\u0005U\u0005\u0002CAM?\u0001\u0006K!!$\t\u000f\u0005mu\u0004\"\u0001\u0002T!I\u0011QT\u0010\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003G{\u0012\u0013!C\u0001\u0003KC\u0011\"a/ \u0003\u0003%\t%!0\t\u0013\u0005-w$!A\u0005\u0002\u00055\u0007\"CAk?\u0005\u0005I\u0011AAl\u0011%\t\toHA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002n~\t\t\u0011\"\u0001\u0002p\"I\u00111_\u0010\u0002\u0002\u0013\u0005\u0013Q\u001f\u0005\n\u0003o|\u0012\u0011!C!\u0003sD\u0011\"a? \u0003\u0003%\t%!@\b\u0011\t\u0005Q\u0004#\u0003A\u0005\u00071\u0001\"!\u0011\u001e\u0011\u0013\u0001%Q\u0001\u0005\u0007ab\"\tAa\u0002\t\u000f\t%\u0001\b\"\u0001\u0003\f!I!Q\u0002\u001d\u0002\u0002\u0013\u0005%q\u0002\u0005\n\u0005'A\u0014\u0011!CA\u0005+A\u0011B!\t9\u0003\u0003%IAa\t\u0006\u000f\t-R\u0004\u0001!\u0003.\tya)\u001a;dQ\u0016$G)\u0019;b!>|GN\u0003\u0002B\u0005\u0006A1m\u001c8tk6,'O\u0003\u0002D\t\u0006A1.\u00194lCB\n\u0004G\u0003\u0002F\r\u0006\u00191/\u001d7\u000b\u0005\u001dC\u0015!B:qCJ\\'BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001e\u001c2\u0001A'T!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011AkV\u0007\u0002+*\u0011aKR\u0001\tS:$XM\u001d8bY&\u0011\u0001,\u0016\u0002\b\u0019><w-\u001b8h\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,7\u0001\u0001\t\u00039\u000el\u0011!\u0018\u0006\u0003=~\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0001\u0017-\u0001\u0003vi&d'\"\u00012\u0002\t)\fg/Y\u0005\u0003Iv\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\u0015\u0019Gn\\2l!\t9\u0017.D\u0001i\u0015\t\u0001g)\u0003\u0002kQ\n)1\t\\8dW\u0006!1m\u001c8g!\tig.D\u0001G\u0013\tygIA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"BA\u001d;vmB\u00111\u000fA\u0007\u0002\u0001\")\u0011\f\u0002a\u00017\")Q\r\u0002a\u0001M\")1\u000e\u0002a\u0001YR\u0011!\u000f\u001f\u0005\u0006s\u0016\u0001\r\u0001\\\u0001\ngB\f'o[\"p]\u001a\fQaY1dQ\u0016,\u0012\u0001 \t\b{\u0006\u0015\u0011\u0011BA\u001b\u001b\u0005q(bA@\u0002\u0002\u00059Q.\u001e;bE2,'bAA\u0002\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\u001daPA\u0002NCB\u0004B!a\u0003\u000209!\u0011QBA\u0016\u001d\u0011\ty!!\u000b\u000f\t\u0005E\u0011q\u0005\b\u0005\u0003'\t)C\u0004\u0003\u0002\u0016\u0005\rb\u0002BA\f\u0003CqA!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;Q\u0016A\u0002\u001fs_>$h(C\u0001L\u0013\tI%*\u0003\u0002H\u0011&\u0011QIR\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0007\u00055\u0002)A\tLC\u001a\\\u0017\rR1uC\u000e{gn];nKJLA!!\r\u00024\tA1)Y2iK.+\u0017PC\u0002\u0002.\u0001\u00032!a\u000e?\u001d\t\u0019H$A\bGKR\u001c\u0007.\u001a3ECR\f\u0007k\\8m!\t\u0019Xd\u0005\u0002\u001e\u001bR\u0011\u00111\b\u0002\u0012\u0007\u0006\u001c\u0007.\u001a3GKR\u001c\u0007.\u001a3ECR\f7CB\u0010N\u0003\u000b\nY\u0005E\u0002O\u0003\u000fJ1!!\u0013P\u0005\u001d\u0001&o\u001c3vGR\u00042ATA'\u0013\r\tye\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fM\u0016$8\r[3e\t\u0006$\u0018-\u0006\u0002\u0002VA\u00191/a\u0016\n\u0007\u0005e\u0003IA\u0006GKR\u001c\u0007.\u001a3ECR\f\u0017\u0001\u00044fi\u000eDW\r\u001a#bi\u0006\u0004C\u0003BA0\u0003G\u00022!!\u0019 \u001b\u0005i\u0002bBA)E\u0001\u0007\u0011QK\u0001\u0016Y\u0006\u001cHOU3mK\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q+\t\tI\u0007E\u0002O\u0003WJ1!!\u001cP\u0005\u0011auN\\4\u000231\f7\u000f\u001e*fY\u0016\f7/\u001a3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003g\nI\bE\u0002O\u0003kJ1!a\u001eP\u0005\u0011)f.\u001b;\t\u0013\u0005mD%!AA\u0002\u0005%\u0014a\u0001=%c\u00051B.Y:u%\u0016dW-Y:fIRKW.Z:uC6\u0004\b%A\u000bmCN$\u0018iY9vSJ,G\rV5nKN$\u0018-\u001c9\u000231\f7\u000f^!dcVL'/\u001a3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003g\n)\tC\u0005\u0002|\u001d\n\t\u00111\u0001\u0002j\u00051B.Y:u\u0003\u000e\fX/\u001b:fIRKW.Z:uC6\u0004\b%A\u0003j]V\u001bX-\u0006\u0002\u0002\u000eB\u0019a*a$\n\u0007\u0005EuJA\u0004C_>dW-\u00198\u0002\u0013%tWk]3`I\u0015\fH\u0003BA:\u0003/C\u0011\"a\u001f+\u0003\u0003\u0005\r!!$\u0002\r%tWk]3!\u0003%9W\r^(cU\u0016\u001cG/\u0001\u0003d_BLH\u0003BA0\u0003CC\u0011\"!\u0015.!\u0003\u0005\r!!\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0015\u0016\u0005\u0003+\nIk\u000b\u0002\u0002,B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016!C;oG\",7m[3e\u0015\r\t)lT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA]\u0003_\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0018\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011QY1\u0002\t1\fgnZ\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001f\u00042ATAi\u0013\r\t\u0019n\u0014\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\fy\u000eE\u0002O\u00037L1!!8P\u0005\r\te.\u001f\u0005\n\u0003w\n\u0014\u0011!a\u0001\u0003\u001f\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003K\u0004b!a:\u0002j\u0006eWBAA\u0001\u0013\u0011\tY/!\u0001\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001b\u000b\t\u0010C\u0005\u0002|M\n\t\u00111\u0001\u0002Z\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002P\u0006AAo\\*ue&tw\r\u0006\u0002\u0002@\u00061Q-];bYN$B!!$\u0002\u0000\"I\u00111\u0010\u001c\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0012\u0007\u0006\u001c\u0007.\u001a3GKR\u001c\u0007.\u001a3ECR\f\u0007cAA1qM!\u0001(TA&)\t\u0011\u0019!A\u0003f[B$\u0018\u0010\u0006\u0002\u0002`\u0005)\u0011\r\u001d9msR!\u0011q\fB\t\u0011\u001d\t\tf\u000fa\u0001\u0003+\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0018\tu\u0001#\u0002(\u0003\u001a\u0005U\u0013b\u0001B\u000e\u001f\n1q\n\u001d;j_:D\u0011Ba\b=\u0003\u0003\u0005\r!a\u0018\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0013!\u0011\t\tMa\n\n\t\t%\u00121\u0019\u0002\u0007\u001f\nTWm\u0019;\u0003+\r\u000b7\r[3e\r\u0016$8\r[3e\t\u0006$\u0018\rT5tiB)QPa\f\u0002`%\u0019!\u0011\u0007@\u0003\u00151K7\u000f\u001e\"vM\u001a,'/\u0001\u0004dC\u000eDW\rI\u0001\u001b[&tWI^5di\u0006\u0014G.Z%eY\u0016$\u0016.\\3NS2d\u0017n]\u0001\u001c[&tWI^5di\u0006\u0014G.Z%eY\u0016$\u0016.\\3NS2d\u0017n\u001d\u0011\u0002=\u00154\u0018n\u0019;peRC'/Z1e%Vt\u0017J\u001c;feZ\fG.T5mY&\u001c\u0018aH3wS\u000e$xN\u001d+ie\u0016\fGMU;o\u0013:$XM\u001d<bY6KG\u000e\\5tA\u0005\u00112\u000f^1si\u00163\u0018n\u0019;peRC'/Z1e)\t\u0011\t\u0005E\u0003O\u00053\u0011\u0019\u0005\r\u0003\u0003F\t=\u0003#\u0002/\u0003H\t-\u0013b\u0001B%;\ny1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0003\u0003N\t=C\u0002\u0001\u0003\f\u0005#b\u0011\u0011!A\u0001\u0006\u0003\u0011\u0019FA\u0002`IE\nBA!\u0016\u0002ZB\u0019aJa\u0016\n\u0007\tesJA\u0004O_RD\u0017N\\4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$WC\u0001B!\u00035\u00198\r[3ek2,Gm\u0018\u0013fcR!\u00111\u000fB2\u0011%\tYHDA\u0001\u0002\u0004\u0011\t%\u0001\u0006tG\",G-\u001e7fI\u0002\nQC\\;n\u0007J,\u0017\r^3e\r\u0016$8\r[3e\t\u0006$\u0018-\u0006\u0002\u0003lA!!Q\u000eB:\u001b\t\u0011yGC\u0002\u0003ru\u000ba!\u0019;p[&\u001c\u0017\u0002\u0002B;\u0005_\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002-9,Xn\u0011:fCR,GMR3uG\",G\rR1uC\u0002\n\u0001C\\;n)>$\u0018\r\\#mK6,g\u000e^:\u0002#9,X\u000eV8uC2,E.Z7f]R\u001c\b%\u0001\u0006ok6\u001c%/Z1uK\u0012\f\u0001B\\;n)>$\u0018\r\\\u0001\bC\u000e\fX/\u001b:f)\u0019\t)F!\"\u0003\n\"9!q\u0011\fA\u0002\u0005%\u0011aA6fs\"9!1\u0012\fA\u0002\u0005%\u0014A\u00053fg&\u0014X\rZ*uCJ$xJ\u001a4tKR\f!\"\u001b8wC2LG-\u0019;f)\u0011\t\u0019H!%\t\u000f\t\u001du\u00031\u0001\u0002\n\u00059!/\u001a7fCN,GCBA:\u0005/\u0013I\nC\u0004\u0003\bb\u0001\r!!\u0003\t\u000f\u0005E\u0003\u00041\u0001\u0002V\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002t\u0005)!/Z:fi\u0006)\"/Z7pm\u0016LE\r\\3GKR\u001c\u0007.\u001a3ECR\f\u0007")
public class FetchedDataPool
implements Logging {
    private final ScheduledExecutorService executorService;
    private final Clock clock;
    private final Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache;
    private final long minEvictableIdleTimeMillis;
    private final long evictorThreadRunIntervalMillis;
    private Option<ScheduledFuture<?>> scheduled;
    private final LongAdder numCreatedFetchedData;
    private final LongAdder numTotalElements;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache() {
        return this.cache;
    }

    private long minEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    private long evictorThreadRunIntervalMillis() {
        return this.evictorThreadRunIntervalMillis;
    }

    private Option<ScheduledFuture<?>> startEvictorThread() {
        if (this.evictorThreadRunIntervalMillis() > 0L) {
            ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(() -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeIdleFetchedData()), 0L, this.evictorThreadRunIntervalMillis(), TimeUnit.MILLISECONDS);
            return new Some(future);
        }
        return None$.MODULE$;
    }

    private Option<ScheduledFuture<?>> scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(Option<ScheduledFuture<?>> x$1) {
        this.scheduled = x$1;
    }

    private LongAdder numCreatedFetchedData() {
        return this.numCreatedFetchedData;
    }

    private LongAdder numTotalElements() {
        return this.numTotalElements;
    }

    public long numCreated() {
        return this.numCreatedFetchedData().sum();
    }

    public long numTotal() {
        return this.numTotalElements().sum();
    }

    public synchronized FetchedData acquire(KafkaDataConsumer.CacheKey key, long desiredStartOffset) {
        ListBuffer fetchedDataList = (ListBuffer)this.cache().getOrElseUpdate((Object)key, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
        Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$acquire$2(desiredStartOffset, p)));
        CachedFetchedData cachedFetchedData = null;
        if (cachedFetchedDataOption.isDefined()) {
            cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
        } else {
            cachedFetchedData = FetchedDataPool$CachedFetchedData$.MODULE$.empty();
            fetchedDataList.$plus$eq((Object)cachedFetchedData);
            this.numCreatedFetchedData().increment();
            this.numTotalElements().increment();
        }
        cachedFetchedData.lastAcquiredTimestamp_$eq(this.clock.getTimeMillis());
        cachedFetchedData.inUse_$eq(true);
        return cachedFetchedData.getObject();
    }

    public synchronized void invalidate(KafkaDataConsumer.CacheKey key) {
        Option option = this.cache().remove((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            ListBuffer lst = (ListBuffer)some.value();
            this.numTotalElements().add(-1 * lst.size());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public synchronized void release(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        Option option = this.cache().get((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            ListBuffer fetchedDataList = (ListBuffer)some.value();
            Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$release$2(fetchedData, p)));
            if (cachedFetchedDataOption.isEmpty()) {
                this.warnReleasedDataNotInPool$1(key, fetchedData);
                return;
            }
            CachedFetchedData cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
            cachedFetchedData.inUse_$eq(false);
            cachedFetchedData.lastReleasedTimestamp_$eq(this.clock.getTimeMillis());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.warnReleasedDataNotInPool$1(key, fetchedData);
            return;
        }
        throw new MatchError((Object)option);
    }

    public void shutdown() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.executorService, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public synchronized void reset() {
        this.scheduled().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cancel(true)));
        this.cache().clear();
        this.numTotalElements().reset();
        this.numCreatedFetchedData().reset();
        this.scheduled_$eq(this.startEvictorThread());
    }

    private synchronized void removeIdleFetchedData() {
        long now = this.clock.getTimeMillis();
        long maxAllowedReleasedTimestamp = now - this.minEvictableIdleTimeMillis();
        this.cache().values().foreach((Function1 & Serializable & scala.Serializable)p -> {
            FetchedDataPool.$anonfun$removeIdleFetchedData$1(this, maxAllowedReleasedTimestamp, p);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$acquire$2(long desiredStartOffset$1, CachedFetchedData p) {
        return !p.inUse() && p.getObject().nextOffsetInFetchedData() == desiredStartOffset$1;
    }

    private final void warnReleasedDataNotInPool$1(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("No matching data in pool for ").append(fetchedData).append(" in key ").append(key).append(". ").append("It might be released before, or it was not a part of pool.").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$release$2(FetchedData fetchedData$2, CachedFetchedData p) {
        if (!p.inUse()) return false;
        FetchedData fetchedData = p.getObject();
        FetchedData fetchedData2 = fetchedData$2;
        if (fetchedData != null) {
            if (!((Object)fetchedData).equals(fetchedData2)) return false;
            return true;
        }
        if (fetchedData2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeIdleFetchedData$2(long maxAllowedReleasedTimestamp$1, CachedFetchedData q) {
        return !q.inUse() && q.lastReleasedTimestamp() < maxAllowedReleasedTimestamp$1;
    }

    public static final /* synthetic */ void $anonfun$removeIdleFetchedData$1(FetchedDataPool $this, long maxAllowedReleasedTimestamp$1, ListBuffer p) {
        ListBuffer expired = (ListBuffer)p.filter((Function1 & Serializable & scala.Serializable)q -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$removeIdleFetchedData$2(maxAllowedReleasedTimestamp$1, q)));
        p.$minus$minus$eq((TraversableOnce)expired);
        $this.numTotalElements().add(-1 * expired.size());
    }

    public FetchedDataPool(ScheduledExecutorService executorService, Clock clock, SparkConf conf) {
        this.executorService = executorService;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.cache = HashMap$.MODULE$.empty();
        this.minEvictableIdleTimeMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_TIMEOUT()));
        this.evictorThreadRunIntervalMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_EVICTOR_THREAD_RUN_INTERVAL()));
        this.scheduled = this.startEvictorThread();
        this.numCreatedFetchedData = new LongAdder();
        this.numTotalElements = new LongAdder();
    }

    public FetchedDataPool(SparkConf sparkConf) {
        this(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kafka-fetched-data-cache-evictor"), (Clock)new SystemClock(), sparkConf);
    }

    public static class CachedFetchedData
    implements Product,
    scala.Serializable {
        private final FetchedData fetchedData;
        private long lastReleasedTimestamp;
        private long lastAcquiredTimestamp;
        private boolean inUse;

        public FetchedData fetchedData() {
            return this.fetchedData;
        }

        public long lastReleasedTimestamp() {
            return this.lastReleasedTimestamp;
        }

        public void lastReleasedTimestamp_$eq(long x$1) {
            this.lastReleasedTimestamp = x$1;
        }

        public long lastAcquiredTimestamp() {
            return this.lastAcquiredTimestamp;
        }

        public void lastAcquiredTimestamp_$eq(long x$1) {
            this.lastAcquiredTimestamp = x$1;
        }

        public boolean inUse() {
            return this.inUse;
        }

        public void inUse_$eq(boolean x$1) {
            this.inUse = x$1;
        }

        public FetchedData getObject() {
            return this.fetchedData();
        }

        public CachedFetchedData copy(FetchedData fetchedData) {
            return new CachedFetchedData(fetchedData);
        }

        public FetchedData copy$default$1() {
            return this.fetchedData();
        }

        public String productPrefix() {
            return "CachedFetchedData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.fetchedData();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CachedFetchedData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CachedFetchedData)) return false;
            boolean bl = true;
            if (!bl) return false;
            CachedFetchedData cachedFetchedData = (CachedFetchedData)x$1;
            FetchedData fetchedData = this.fetchedData();
            FetchedData fetchedData2 = cachedFetchedData.fetchedData();
            if (fetchedData == null) {
                if (fetchedData2 != null) {
                    return false;
                }
            } else if (!((Object)fetchedData).equals(fetchedData2)) return false;
            if (!cachedFetchedData.canEqual(this)) return false;
            return true;
        }

        public CachedFetchedData(FetchedData fetchedData) {
            this.fetchedData = fetchedData;
            Product.$init$((Product)this);
            this.lastReleasedTimestamp = Long.MAX_VALUE;
            this.lastAcquiredTimestamp = Long.MIN_VALUE;
            this.inUse = false;
        }
    }
}

