/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrixImpl;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u000f\u001f\u0001%B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001da\u0007A1A\u0005\u00025DaA \u0001!\u0002\u0013q\u0007BB/\u0001\t\u0003\t\t\u0001C\u0004^\u0001\u0011\u0005\u0001%!\u0004\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u001fBq!!\u0018\u0001\t\u0003\t)\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002P!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0003bBA9\u0001\u0011\u0005\u0011q\n\u0005\r\u0003k\u0002\u0001\u0013!EDB\u0013%\u0011q\u000f\u0005\u000b\u0003+\u0003\u0001R1A\u0005\n\u0005]\u0005BCAM\u0001!\u0015\r\u0011\"\u0003\u0002\u001c\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAO\u0001\u0011%\u00111V\u0004\n\u0003ks\u0012\u0011!E\u0001\u0003o3\u0001\"\b\u0010\u0002\u0002#\u0005\u0011\u0011\u0018\u0005\u0007;j!\t!a/\t\u0013\u0005u&$%A\u0005\u0002\u0005}&a\u0007\"j]\u0006\u0014\u0018p\u00117bgNLg-[2bi&|g.T3ue&\u001c7O\u0003\u0002 A\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013!B7mY&\u0014'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\tD'D\u00013\u0015\t\u0019$%\u0001\u0005j]R,'O\\1m\u0013\t)$GA\u0004M_\u001e<\u0017N\\4\u0002\u001dM\u001cwN]3B]\u0012d\u0015MY3mgV\t\u0001\b\r\u0002:\u0003B\u0019!(P \u000e\u0003mR!\u0001\u0010\u0012\u0002\u0007I$G-\u0003\u0002?w\t\u0019!\u000b\u0012#\u0011\u0005\u0001\u000bE\u0002\u0001\u0003\n\u0005\n\t\t\u0011!A\u0003\u00025\u00131a\u0018\u00132\u0003=\u00198m\u001c:f\u0003:$G*\u00192fYN\u0004\u0003f\u0001\u0002F\u0017B\u0011a)S\u0007\u0002\u000f*\u0011\u0001JI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001&H\u0005\u0015\u0019\u0016N\\2fC\u0005a\u0015!B\u0019/g9\u0002\u0014C\u0001(R!\tYs*\u0003\u0002QY\t9aj\u001c;iS:<\u0007CA\u0016S\u0013\t\u0019FFA\u0004Qe>$Wo\u0019;)\u0007\u0005)5*A\u0004ok6\u0014\u0015N\\:\u0016\u0003]\u0003\"a\u000b-\n\u0005ec#aA%oi\"\u001a1!R&\u0002\u00119,XNQ5og\u0002B3\u0001B#L\u0003\u0019a\u0014N\\5u}Q\u0019q,Y4\u0011\u0005\u0001\u0004Q\"\u0001\u0010\t\u000bY*\u0001\u0019\u000121\u0005\r,\u0007c\u0001\u001e>IB\u0011\u0001)\u001a\u0003\n\u0005\u0006\f\t\u0011!A\u0003\u00025C3!Y#L\u0011\u001d)V\u0001%AA\u0002]C3aZ#LQ\r)QI[\u0011\u0002W\u0006)1G\f\u0019/a\u0005\t2oY8sK2\u000b'-\u001a7t/\u0016Lw\r\u001b;\u0016\u00039\u00042AO\u001fp!\u0011Y\u0003O];\n\u0005Ed#A\u0002+va2,'\u0007\u0005\u0002,g&\u0011A\u000f\f\u0002\u0007\t>,(\r\\3\u0011\t-\u0002(O\u001d\u0015\u0005\r]TH\u0010\u0005\u0002,q&\u0011\u0011\u0010\f\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%A>\u0002!RCW\r\t<be&\f'\r\\3!AN\u001cwN]3MC\n,Gn],fS\u001eDG\u000f\u0019\u0011tQ>,H\u000e\u001a\u0011cK\u0002\u0002(/\u001b<bi\u0016\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000e\t\u001b/a9\u0002d&I\u0001~\u0003\u0015\u0019d\u0006\u000e\u00181\u0003I\u00198m\u001c:f\u0019\u0006\u0014W\r\\:XK&<\u0007\u000e\u001e\u0011)\t\u001d9(\u0010 \u000b\u0004?\u0006\r\u0001B\u0002\u001c\t\u0001\u0004\t)\u0001E\u0002;{UDC\u0001C#\u0002\n\u0005\u0012\u00111B\u0001\u0006c9\u0002d\u0006\r\u000b\u0004?\u0006=\u0001B\u0002\u001c\n\u0001\u0004\t\t\u0002\u0005\u0003\u0002\u0014\u0005Mb\u0002BA\u000b\u0003[qA!a\u0006\u0002*9!\u0011\u0011DA\u0014\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t)\u0003\u0019a$o\\8u}%\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0004\u0003W\u0011\u0013aA:rY&!\u0011qFA\u0019\u0003\u001d\u0001\u0018mY6bO\u0016T1!a\u000b#\u0013\u0011\t)$a\u000e\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\u0018\u0003c\t\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u0005\u0005u\u0002cA\u0016\u0002@%\u0019\u0011\u0011\t\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0015\u0015\u000bI!\u0001\u0006uQJ,7\u000f[8mIN$\"!!\u0013\u0011\u0007ij$\u000f\u000b\u0003\f\u000b\u0006%\u0011a\u0001:pGR\u0011\u0011Q\u0001\u0015\u0005\u0019\u0015\u000bI!\u0001\u0007be\u0016\fWK\u001c3feJ{5\tF\u0001sQ\u0011iQ)!\u0003\u0002\u0005A\u0014\b\u0006\u0002\bF\u0003\u0013\t1\"\u0019:fCVsG-\u001a:Q%\"\"q\"RA\u0005\u0003M1W*Z1tkJ,')\u001f+ie\u0016\u001c\bn\u001c7e)\u0011\t)!!\u001a\t\r\u0005\u001d\u0004\u00031\u0001s\u0003\u0011\u0011W\r^1)\tA)\u0015\u0011\u0002\u0015\u0005#\u0015\u000bI!\u0001\u000bqe\u0016\u001c\u0017n]5p]\nKH\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0005%\u0015\u000bI!A\tsK\u000e\fG\u000e\u001c\"z)\"\u0014Xm\u001d5pY\u0012DCaE#\u0002\n\u0005\u0019\u0001\u0010J\u001a\u0016\u0005\u0005e\u0004CB\u0016q\u0003w\nY\t\u0005\u0003;{\u0005u\u0004#B\u0016qe\u0006}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015e$\u0001\u0004cS:\f'/_\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\nCS:\f'/\u001f'bE\u0016d7i\\;oi\u0016\u0014\b\u0003\u0002\u001e>\u0003\u001b\u0003Ra\u000b9s\u0003\u001f\u0003B!!!\u0002\u0012&!\u00111SAB\u0005U\u0011\u0015N\\1ss\u000e{gNZ;tS>tW*\u0019;sSb\f\u0001cY;nk2\fG/\u001b<f\u0007>,h\u000e^:\u0016\u0005\u0005m\u0014AC2p]\u001a,8/[8ogV\u0011\u00111R\u0001\fGJ,\u0017\r^3DkJ4X\r\u0006\u0003\u0002\u0006\u0005\u0005\u0006bBAR/\u0001\u0007\u0011QU\u0001\u0002sB!\u0011\u0011QAT\u0013\u0011\tI+a!\u0003E\tKg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o\u001b\u0016$(/[2D_6\u0004X\u000f^3s)\u0019\t)!!,\u00022\"9\u0011q\u0016\rA\u0002\u0005\u0015\u0016!\u0001=\t\u000f\u0005\r\u0006\u00041\u0001\u0002&\"\"\u0001!RA\u0005\u0003m\u0011\u0015N\\1ss\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6+GO]5dgB\u0011\u0001MG\n\u00035)\"\"!a.\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tMK\u0002X\u0003\u0007\\#!!2\u0011\t\u0005\u001d\u0017qZ\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u00112JA!!5\u0002J\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class BinaryClassificationMetrics
implements Logging {
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private final RDD<? extends Product> scoreAndLabels;
    private final int numBins;
    private final RDD<Tuple2<Object, Tuple2<Object, Object>>> scoreLabelsWeight;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$2() {
        return BinaryClassificationMetrics$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<? extends Product> scoreAndLabels() {
        return this.scoreAndLabels;
    }

    public int numBins() {
        return this.numBins;
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>>> scoreLabelsWeight() {
        return this.scoreLabelsWeight;
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        int numParts = rocCurve.getNumPartitions();
        return rocCurve.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BinaryClassificationMetrics.$anonfun$roc$1(numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), rocCurve.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        Tuple2 tuple2 = (Tuple2)prCurve.first();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double firstPrecision = tuple2._2$mcD$sp();
        double firstPrecision2 = firstPrecision;
        return prCurve.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BinaryClassificationMetrics.$anonfun$pr$1(firstPrecision2, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), prCurve.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3$lzycompute() {
        block10: {
            BinaryClassificationMetrics binaryClassificationMetrics = this;
            synchronized (binaryClassificationMetrics) {
                RDD rDD;
                RDD confusions;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        RDD rDD2;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block10;
                        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.scoreLabelsWeight(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1 & Serializable & scala.Serializable)labelAndWeight -> new BinaryLabelCounter(0.0, 0.0).$plus$eq(labelAndWeight._1$mcD$sp(), labelAndWeight._2$mcD$sp()), (Function2 & Serializable & scala.Serializable)(c, labelAndWeight) -> c.$plus$eq(labelAndWeight._1$mcD$sp(), labelAndWeight._2$mcD$sp()), (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.$plus$eq((BinaryLabelCounter)c2)), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                        boolean x$1 = false;
                        int x$2 = qual$1.sortByKey$default$2();
                        RDD counts = qual$1.sortByKey(x$1, x$2);
                        if (this.numBins() == 0) {
                            rDD2 = counts;
                        } else {
                            long countsSize = counts.count();
                            long grouping = countsSize / (long)this.numBins();
                            if (grouping < 2L) {
                                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Curve is too small (").append(countsSize).append(") for ").append(this.numBins()).append(" bins to be useful").toString());
                                rDD2 = counts;
                            } else {
                                rDD2 = counts.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                                    if (iter.hasNext()) {
                                        DoubleRef score = DoubleRef.create((double)Double.NaN);
                                        ObjectRef agg = ObjectRef.create((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()));
                                        LongRef cnt = LongRef.create((long)0L);
                                        return iter.flatMap((Function1 & Serializable & scala.Serializable)pair -> {
                                            score$1.elem = pair._1$mcD$sp();
                                            ((BinaryLabelCounter)agg$1.elem).$plus$eq((BinaryLabelCounter)pair._2());
                                            ++cnt$1.elem;
                                            if (cnt$1.elem == grouping) {
                                                Tuple2 ret = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score$1.elem), (Object)((BinaryLabelCounter)agg$1.elem));
                                                agg$1.elem = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                                                cnt$1.elem = 0L;
                                                return Option$.MODULE$.option2Iterable((Option)new Some((Object)ret));
                                            }
                                            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                        }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> {
                                            if (cnt$1.elem > 0L) {
                                                return package$.MODULE$.Iterator().single((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)score$1.elem), (Object)((BinaryLabelCounter)agg$1.elem)));
                                            }
                                            return package$.MODULE$.Iterator().empty();
                                        });
                                    }
                                    return package$.MODULE$.Iterator().empty();
                                }, counts.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                            }
                        }
                        RDD binnedCounts = rDD2;
                        RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(binnedCounts, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.Double$.MODULE$).values();
                        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)iter -> {
                            BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                            iter.foreach((Function1 & Serializable & scala.Serializable)x$2 -> agg.$plus$eq((BinaryLabelCounter)x$2));
                            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryLabelCounter[]{agg}));
                        };
                        boolean x$4 = qual$2.mapPartitions$default$2();
                        BinaryLabelCounter[] agg2 = (BinaryLabelCounter[])qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                        BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])agg2)).scanLeft((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2 & Serializable & scala.Serializable)(agg, c) -> agg.clone().$plus$eq((BinaryLabelCounter)c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryLabelCounter.class)));
                        BinaryLabelCounter totalCount = (BinaryLabelCounter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts)).last();
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Total counts: ").append(totalCount).toString());
                        RDD cumulativeCounts = binnedCounts.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, iter) -> BinaryClassificationMetrics.$anonfun$x$3$12(partitionwiseCumulativeCounts, BoxesRunTime.unboxToInt((Object)index), iter), true, ClassTag$.MODULE$.apply(Tuple2.class));
                        cumulativeCounts.persist();
                        RDD confusions2 = cumulativeCounts.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                double score = tuple2._1$mcD$sp();
                                BinaryLabelCounter cumCount = (BinaryLabelCounter)tuple2._2();
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)new BinaryConfusionMatrixImpl(cumCount, totalCount));
                            }
                            throw new MatchError((Object)tuple2);
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        tuple2 = new Tuple2((Object)cumulativeCounts, (Object)confusions2);
                        if (tuple2 == null) break block11;
                        RDD cumulativeCounts2 = (RDD)tuple2._1();
                        confusions = (RDD)tuple2._2();
                        if (cumulativeCounts2 == null) break block11;
                        rDD = cumulativeCounts2;
                        if (confusions != null) break block12;
                    }
                    throw new MatchError((Object)tuple2);
                }
                RDD rDD3 = confusions;
                this.x$3 = new Tuple2((Object)rDD, (Object)rDD3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$3;
    }

    private /* synthetic */ Tuple2 x$3() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$3$lzycompute();
        }
        return this.x$3;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$3()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.cumulativeCounts$lzycompute();
        }
        return this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$3()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.confusions;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.confusions$lzycompute();
        }
        return this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double s = tuple2._1$mcD$sp();
                BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                return new Tuple2.mcDD.sp(s, y.apply(c));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                return new Tuple2.mcDD.sp(x.apply(c), y.apply(c));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ Iterator $anonfun$roc$1(int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int pid = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            if (numParts$1 == 1) {
                Predef$.MODULE$.require(pid == 0);
                return package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, 0.0)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter).$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(1.0, 1.0)));
            }
            if (pid == 0) {
                return package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, 0.0)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter);
            }
            if (pid == numParts$1 - 1) {
                return iter.$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(1.0, 1.0)));
            }
            return iter;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Iterator $anonfun$pr$1(double firstPrecision$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int pid = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            if (pid == 0) {
                return package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, firstPrecision$1)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter);
            }
            return iter;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Iterator $anonfun$x$3$12(BinaryLabelCounter[] partitionwiseCumulativeCounts$1, int index, Iterator iter) {
        BinaryLabelCounter cumCount = partitionwiseCumulativeCounts$1[index];
        return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double score = tuple2._1$mcD$sp();
                BinaryLabelCounter c = (BinaryLabelCounter)tuple2._2();
                cumCount.$plus$eq(c);
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)cumCount.clone());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public BinaryClassificationMetrics(RDD<? extends Product> scoreAndLabels, int numBins) {
        this.scoreAndLabels = scoreAndLabels;
        this.numBins = numBins;
        Logging.$init$((Logging)this);
        this.scoreLabelsWeight = scoreAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product = x0$1;
            if (product instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)product;
                Object prediction = tuple3._1();
                Object label = tuple3._2();
                Object weight = tuple3._3();
                if (prediction instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (label instanceof Double) {
                        double d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                            Predef$.MODULE$.require(d3 >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("instance weight, ").append(d3).append(" has to be >= 0.0").toString());
                            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)new Tuple2.mcDD.sp(d2, d3));
                        }
                    }
                }
            }
            if (product instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)product;
                Object prediction = tuple2._1();
                Object label = tuple2._2();
                if (prediction instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (label instanceof Double) {
                        double d4 = BoxesRunTime.unboxToDouble((Object)label);
                        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)new Tuple2.mcDD.sp(d4, 1.0));
                    }
                }
            }
            throw new IllegalArgumentException(new StringBuilder(21).append("Expected tuples, got ").append(product).toString());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.require(numBins >= 0, (Function0 & Serializable & scala.Serializable)() -> "numBins must be nonnegative");
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this(scoreAndLabels, 0);
    }

    public BinaryClassificationMetrics(Dataset<Row> scoreAndLabels) {
        this((RDD<? extends Product>)scoreAndLabels.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Row x0$1) {
                Some some;
                Row row = x0$1;
                Some some2 = Row$.MODULE$.unapplySeq(row);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(3) == 0) {
                    Object prediction = ((SeqLike)some2.get()).apply(0);
                    Object label = ((SeqLike)some2.get()).apply(1);
                    Object weight = ((SeqLike)some2.get()).apply(2);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                            }
                        }
                    }
                }
                if (!(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d4 = BoxesRunTime.unboxToDouble((Object)label);
                            return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d4), (Object)BoxesRunTime.boxToDouble((double)1.0));
                        }
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)), BinaryClassificationMetrics$.MODULE$.$lessinit$greater$default$2());
    }
}

