/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.logstore;

import io.delta.kernel.defaults.internal.DefaultEngineErrors;
import io.delta.storage.AzureLogStore;
import io.delta.storage.GCSLogStore;
import io.delta.storage.HDFSLogStore;
import io.delta.storage.LogStore;
import io.delta.storage.S3SingleDriverLogStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(LogStoreProvider.class);
    private static final Set<String> S3_SCHEMES = LogStoreProvider.unmodifiableSet("s3", "s3a", "s3n");
    private static final Set<String> AZURE_SCHEMES = LogStoreProvider.unmodifiableSet("abfs", "abfss", "adl", "wasb", "wasbs");
    private static final Set<String> GCS_SCHEMES = LogStoreProvider.unmodifiableSet("gs");

    public static LogStore getLogStore(Configuration configuration, String string) {
        String string2 = Optional.ofNullable(string).map(String::toLowerCase).orElse(null);
        String string3 = configuration.get(LogStoreProvider.getLogStoreSchemeConfKey(string2));
        if (string3 != null) {
            return LogStoreProvider.createLogStore(string3, configuration, "from config");
        }
        String string4 = HDFSLogStore.class.getName();
        if (S3_SCHEMES.contains(string2)) {
            string4 = S3SingleDriverLogStore.class.getName();
        } else if (AZURE_SCHEMES.contains(string2)) {
            string4 = AzureLogStore.class.getName();
        } else if (GCS_SCHEMES.contains(string2)) {
            string4 = GCSLogStore.class.getName();
        }
        return LogStoreProvider.createLogStore(string4, configuration, "(default for file scheme)");
    }

    static String getLogStoreSchemeConfKey(String string) {
        return "io.delta.kernel.logStore." + string + ".impl";
    }

    private static Class<? extends LogStore> getLogStoreClass(String string) throws ClassNotFoundException {
        return Class.forName(string).asSubclass(LogStore.class);
    }

    private static LogStore createLogStore(String string, Configuration configuration, String string2) {
        try {
            return LogStoreProvider.getLogStoreClass(string).getConstructor(Configuration.class).newInstance(configuration);
        }
        catch (Exception exception) {
            String string3 = "Failed to instantiate LogStore class ({}): {}";
            logger.error(string3, new Object[]{string2, string, exception});
            throw DefaultEngineErrors.canNotInstantiateLogStore(string, string2, exception);
        }
    }

    private static Set<String> unmodifiableSet(String ... stringArray) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }
}

