/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.AbstractCalibrator;
import java.util.Arrays;

public class IsotonicCalibrator
extends AbstractCalibrator {
    private double[][] xArray;
    private double[][] yArray;
    private int nClasses;

    public IsotonicCalibrator(double[][] xArray, double[][] yArray, boolean fromProba) {
        super(fromProba);
        if (xArray.length != yArray.length || xArray[0].length != yArray[0].length) {
            throw new IllegalArgumentException("x and y arrays don't have a consistent shapes (x: " + xArray.length + " " + xArray[0].length + ", y: " + yArray.length + " " + yArray[0].length + ")");
        }
        this.xArray = xArray;
        this.yArray = yArray;
        this.nClasses = xArray.length > 2 ? yArray.length : 2;
    }

    @Override
    public double[] getCalibratedProbabilities(double[] input) {
        double[] calibratedProbas = new double[this.nClasses];
        double norm = 0.0;
        if (this.nClasses == 2) {
            double x = input[1];
            double p = this.interpolate1D(x, this.xArray[0], this.yArray[0]);
            calibratedProbas[1] = p >= 0.0 ? (p <= 1.0 ? p : 1.0) : 0.0;
            calibratedProbas[0] = 1.0 - calibratedProbas[1];
        } else {
            int k;
            for (k = 0; k < this.nClasses; ++k) {
                double x = input[k];
                double p = this.interpolate1D(x, this.xArray[k], this.yArray[k]);
                calibratedProbas[k] = p >= 0.0 ? (p <= 1.0 ? p : 1.0) : 0.0;
                norm += calibratedProbas[k];
            }
            k = 0;
            while (k < this.nClasses) {
                int n = k++;
                calibratedProbas[n] = calibratedProbas[n] / norm;
            }
        }
        return calibratedProbas;
    }

    private double interpolate1D(double x, double[] xs, double[] ys) {
        int iSearch = Arrays.binarySearch(xs, x);
        if (iSearch >= 0) {
            return ys[iSearch];
        }
        int iHigh = -iSearch - 1;
        if (iHigh >= xs.length) {
            return ys[xs.length - 1];
        }
        if (iHigh == 0) {
            return ys[0];
        }
        int iLow = iHigh - 1;
        double slope = (ys[iHigh] - ys[iLow]) / (xs[iHigh] - xs[iLow]);
        return ys[iLow] + slope * (x - xs[iLow]);
    }
}

