/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.SortResponse;
import org.apache.directory.api.ldap.model.message.controls.SortResponseImpl;
import org.apache.directory.api.util.Strings;

public class SortResponseFactory
extends AbstractControlFactory<SortResponse> {
    public static final int ATTRIBUTE_TYPE_TAG = 128;

    public SortResponseFactory(LdapApiService codec) {
        super(codec, "1.2.840.113556.1.4.474");
    }

    @Override
    public SortResponse newControl() {
        return new SortResponseImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        SortResponse sortResponse = (SortResponse)control;
        int start = buffer.getPos();
        if (sortResponse.getAttributeName() != null) {
            BerValue.encodeOctetString(buffer, (byte)-128, Strings.getBytesUtf8Ascii(sortResponse.getAttributeName()));
        }
        BerValue.encodeEnumerated(buffer, sortResponse.getSortResult().getVal());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new SortResponseContainer(control), control, controlBytes);
    }
}

