/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.lambda.mgmt.PackagesMgmtServiceImpl;
import com.dataiku.dip.lambda.mgmt.PackagesService;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareLambdaPackageStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        public String getType() {
            return "prepare_lambda_package";
        }

        public Class<? extends StepParams> paramsClass() {
            return PrepareLambdaPackageStepParams.class;
        }

        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new PrepareLambdaPackageStepRunner(scenario, step, (PrepareLambdaPackageStepParams)step.getParamsAs(PrepareLambdaPackageStepParams.class));
        }

        public String buildName(Step step) {
            PrepareLambdaPackageStepParams params = (PrepareLambdaPackageStepParams)step.getParamsAs(PrepareLambdaPackageStepParams.class);
            Object name = "Make package";
            if (StringUtils.isNotBlank((String)params.serviceId)) {
                name = (String)name + " for " + params.serviceId;
            }
            return name;
        }

        public String buildId(Step step) {
            PrepareLambdaPackageStepParams params = (PrepareLambdaPackageStepParams)step.getParamsAs(PrepareLambdaPackageStepParams.class);
            return "package " + params.serviceId;
        }

        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final PrepareLambdaPackageStepParams params;
    private final Step step;
    private final Scenario scenario;
    @Autowired
    private PackagesMgmtServiceImpl packagesMgmtService;
    @Autowired
    private PackagesService packagesService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.prepare_lambda_package");

    public PrepareLambdaPackageStepRunner(Scenario scenario, Step step, PrepareLambdaPackageStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    private void publishOnDeployer(String serviceId, String packageId, String projectKey, StepRun stepRun, String publishedServiceId) throws IOException, UnauthorizedException {
        ReportItem.PublishedLambdaService publishedItem = new ReportItem.PublishedLambdaService((ReportTargetItem)new ReportTargetItem.LambdaServiceItem(null, publishedServiceId)).withPackageId(packageId);
        publishedItem.withStart(DateTime.now().getMillis());
        try {
            logger.info((Object)"Publishing new version on Deployer");
            File pckFile = ApplicationConfigurator.getFile((String[])new String[]{"apinode-packages", projectKey, serviceId, packageId, "package.zip"});
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
            switch (ref.mode) {
                case DISABLED: {
                    throw ErrorContext.iae((String)"Deployer support is disabled");
                }
                case LOCAL: {
                    try (FileInputStream is = new FileInputStream(pckFile);){
                        ((PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class)).publishVersionFromStream_NT_Check(publishedServiceId, (InputStream)is, (AuthCtx)stepRun.getScenarioRun().getRunAsUser());
                        break;
                    }
                }
                case REMOTE: {
                    try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, (AuthCtx)stepRun.getScenarioRun().getRunAsUser());){
                        client.publishVersion(publishedServiceId, packageId, pckFile);
                        break;
                    }
                }
            }
            publishedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            logger.info((Object)"Done publishing on Deployer");
        }
        catch (Throwable ex) {
            publishedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, serviceId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)publishedItem);
        }
    }

    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        String publishedServiceId;
        SerializedProject project;
        LambdaService service;
        logger.info((Object)("Start step " + this.step.name));
        VariablesContext variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        String serviceId = this.params.serviceId;
        if (StringUtils.isBlank((String)serviceId)) {
            throw new IllegalArgumentException("Cannot package undefined service");
        }
        String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            service = (LambdaService)this.lambdaServicesDAO.getMandatory(projectKey, serviceId);
            project = this.projectsService.getMandatory(projectKey);
        }
        String packageId = this.params.packageId;
        if (StringUtils.isBlank((String)packageId)) {
            packageId = "";
        }
        logger.info((Object)("Raw packageId " + packageId));
        packageId = substitutor.replace(packageId);
        logger.info((Object)("Replaced packageId " + packageId));
        if (this.params.transmogrify) {
            StringTransmogrifier transmogrifier = new StringTransmogrifier("");
            for (File p : this.packagesService.list(projectKey, this.params.serviceId)) {
                transmogrifier.addAlreadyTransmogrified(p.getName());
            }
            packageId = transmogrifier.transmogrify(packageId);
            logger.info((Object)("Transmogrified packageId " + packageId));
        }
        if (StringUtils.isNotBlank((String)(publishedServiceId = this.params.publishedServiceId))) {
            logger.info((Object)("Raw new service Id " + publishedServiceId));
            publishedServiceId = substitutor.replace(publishedServiceId);
            logger.info((Object)("Replaced new service Id " + publishedServiceId));
        } else {
            publishedServiceId = serviceId;
        }
        if (StringUtils.isNotBlank((String)this.params.releaseNotes)) {
            service.releaseNotes = variablesContext.expandAllowUnresolved(this.params.releaseNotes).trim();
            logger.info((Object)"Expanded variables in release notes");
        }
        ReportItem.MadeLambdaPackage packagedItem = new ReportItem.MadeLambdaPackage((ReportTargetItem)new ReportTargetItem.LambdaServiceItem(projectKey, serviceId)).withPackageId(packageId);
        packagedItem.withStart(DateTime.now().getMillis());
        try {
            FutureResponse fr;
            File destdir = this.packagesService.mkdir(projectKey, serviceId, packageId);
            try (Transaction t = this.transactionService.beginRead();){
                fr = this.packagesMgmtService.startGeneratingPackage(destdir, projectKey, service, project.permissions, (AuthCtx)stepRun.getScenarioRun().getRunAsUser(), false);
            }
            fr = this.futureService.waitForFinalResponse(fr);
            if (fr.result != null) {
                logger.info((Object)("Packaging report : " + ((InfoMessage.InfoMessages)fr.result).report()));
            }
            packagedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            if (StringUtils.isNotBlank((String)this.params.targetVariable)) {
                logger.info((Object)("Setting variable " + this.params.targetVariable + " to new version id: " + packageId));
                stepRun.getScenarioRun().getVariables().addProperty(this.params.targetVariable, packageId);
            }
        }
        catch (Throwable ex) {
            packagedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, serviceId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)packagedItem);
        }
        if (this.params.publishToAPIDeployer && packagedItem.outcome == ReportItem.Outcome.SUCCESS) {
            this.publishOnDeployer(serviceId, packageId, projectKey, stepRun, publishedServiceId);
        }
        logger.info((Object)("Done step " + this.step.name));
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class PrepareLambdaPackageStepParams
    implements StepParams {
        public String serviceId;
        public String packageId;
        public boolean transmogrify;
        public String targetVariable;
        @Nullable
        public String releaseNotes;
        public boolean publishToAPIDeployer;
        public String publishedServiceId;
    }
}

