/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewCRUDService;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewHumanReview;
import com.dataiku.dip.agentreview.AgentReviewResult;
import com.dataiku.dip.agentreview.AgentReviewRun;
import com.dataiku.dip.agentreview.AgentReviewService;
import com.dataiku.dip.agentreview.AgentReviewTest;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewTraitOverride;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIAgentReviewController
extends PublicAPIControllerBase {
    private final AgentReviewService agentReviewService;
    private final AgentReviewCRUDService agentReviewCRUDService;
    private final TransactionService transactionService;
    private final MetaAuthService authService;
    private final ProjectsService projectsService;
    private final AuditTrailService auditTrailService;

    public PublicAPIAgentReviewController(AgentReviewService agentReviewService, AgentReviewCRUDService agentReviewCRUDService, TransactionService transactionService, MetaAuthService authService, ProjectsService projectsService, AuditTrailService auditTrailService) {
        this.agentReviewService = agentReviewService;
        this.agentReviewCRUDService = agentReviewCRUDService;
        this.transactionService = transactionService;
        this.authService = authService;
        this.projectsService = projectsService;
        this.auditTrailService = auditTrailService;
    }

    @AuditedCall(value={"msgType", "agentreview-review-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReview> listAgentReviews(HttpServletRequest req, @PathVariable String projectKey) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = this.agentReviewCRUDService.list(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "agentreview-review-upsert", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReview upsertAgentReview(HttpServletRequest req, @PathVariable String projectKey, @RequestBody AgentReview agentReview) throws DKUSecurityException, IOException, CodedException, LicenseRestrictionException {
        AgentReview savedAgentReview;
        if (!Objects.equals(projectKey, agentReview.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsService.checkPerm(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            savedAgentReview = this.agentReviewCRUDService.upsertAgentReview(t.getUser(), agentReview, false);
            t.commit("Saved agent review %s in project %s ".formatted(agentReview.name, projectKey));
        }
        return savedAgentReview;
    }

    @AuditedCall(value={"msgType", "agentreview-review-get", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReview getAgentReview(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId) throws DKUSecurityException, CodedException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            AgentReview agentReview = this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            return agentReview;
        }
    }

    @AuditedCall(value={"msgType", "agentreview-review-delete", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteAgentReview(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId) throws DKUSecurityException, CodedException, IOException, SQLException {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.agentReviewCRUDService.clearAgentReviewForDeletion(projectKey, agentReviewId);
            this.agentReviewCRUDService.delete(authCtx, projectKey, agentReviewId, Collections.emptySet());
            t.commit("Deleted agent review %s in project %s ".formatted(agentReviewId, projectKey));
        }
    }

    @AuditedCall(value={"msgType", "agentreview-test-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/tests"}, method={RequestMethod.GET})
    public void listTests(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentReviewId, @RequestParam(required=false) List<String> testIds) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIAgentReviewController.streamJSONArray((HttpServletResponse)resp, (Flux)this.agentReviewService.streamTests(projectKey, agentReviewId, testIds));
    }

    @AuditedCall(value={"msgType", "agentreview-test-get", "projectKey", "${projectKey}", "testId", "${testId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/tests/{testId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewTest getTest(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String testId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.getTest(projectKey, testId);
    }

    @AuditedCall(value={"msgType", "agentreview-test-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/tests"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewTest createTest(HttpServletRequest req, @PathVariable String projectKey, @RequestBody AgentReviewTest test) throws DKUSecurityException, SQLException, IOException, CodedException {
        AuthCtx authCtx;
        if (!Objects.equals(projectKey, test.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
            this.agentReviewCRUDService.getMandatory(test.projectKey, test.agentReviewId);
        }
        return this.agentReviewService.createTest(authCtx, test);
    }

    @AuditedCall(value={"msgType", "agentreview-test-create-from-dataset", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "fullDatasetName", "${fullDatasetName}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/tests/actions/create-from-dataset"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AgentReviewCreateTestsFromDatasetResult> createTestsFromDataset(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @RequestParam String fullDatasetName, @RequestBody AgentReviewCreateTestsFromDatasetRequest request) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart((String)projectKey, (String)fullDatasetName);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
            this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, (AnyLoc)datasetLoc);
        }
        return this.agentReviewService.createTestsFromDataset(authCtx, projectKey, agentReviewId, datasetLoc, request);
    }

    @AuditedCall(value={"msgType", "agentreview-test-export-to-dataset", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "fullDatasetName", "${fullDatasetName}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/tests/actions/export-to-dataset"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AgentReviewExportTestsToDatasetResult> exportTestsToDataset(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @RequestParam String fullDatasetName, @RequestBody AgentReviewExportTestsToDatasetRequest request) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart((String)projectKey, (String)fullDatasetName);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            this.projectsService.hasPermissionRegardlessOfContext(authCtx, projectKey, ITaggingService.TaggableType.DATASET, datasetLoc.getFullName(), SerializedProject.ReaderAuthorization.Mode.WRITE);
        }
        return this.agentReviewService.exportTestsToDataset(authCtx, projectKey, agentReviewId, datasetLoc, request);
    }

    @AuditedCall(value={"msgType", "agentreview-test-delete", "projectKey", "${projectKey}", "testId", "${testId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/tests/{testId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTest(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String testId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteTest(projectKey, testId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/tests/{testId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public AgentReviewTest updateTest(HttpServletRequest req, @PathVariable String testId, @RequestBody AgentReviewTest test) throws DKUSecurityException, SQLException {
        AuthCtx authCtx;
        if (!Objects.equals(testId, test.id)) {
            throw new IllegalArgumentException("Test id in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, test.projectKey);
        }
        this.auditTrailService.generic("agentreview-test-update").with("projectKey", test.projectKey).with("testId", test.id).emit();
        return this.agentReviewService.updateTest(authCtx, test);
    }

    @AuditedCall(value={"msgType", "agentreview-run-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewRun> listRuns(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.listRuns(projectKey, agentReviewId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-get", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/{runId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewRun getRun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @PathVariable String runId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.getRun(projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-delete", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/{runId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteRun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @PathVariable String runId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteRun(projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-execute", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun performRun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @RequestParam(required=false) List<String> testIds, @RequestParam(required=false, defaultValue="true") boolean wait, @RequestParam(required=false) String runName) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.performRun_NT(authCtx, projectKey, agentReviewId, testIds, wait, false, runName);
    }

    @AuditedCall(value={"msgType", "agentreview-rerun-execute", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/actions/rerun"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun rerun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @RequestParam String runId, @RequestParam(required=false, defaultValue="true") boolean wait, @RequestParam(required=false) String runName) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        return this.agentReviewService.rerun_NT(authCtx, projectKey, agentReviewId, wait, false, runId, runName);
    }

    @AuditedCall(value={"msgType", "agentreview-run-abort", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/{runId}/actions/abort"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun abortRun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @PathVariable String runId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.abortRun(authCtx, projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-rename", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/{runId}/actions/rename"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun renameRun(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @PathVariable String runId, @RequestParam String newName) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        return this.agentReviewService.renameRun(projectKey, agentReviewId, runId, newName);
    }

    @AuditedCall(value={"msgType", "agentreview-run-traits", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "run", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/reviews/{agentReviewId}/runs/{runId}/traits"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewTrait> getRunTraits(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentReviewId, @PathVariable String runId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.listTraitsForRun(projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-result-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/results"}, method={RequestMethod.GET})
    public void listResults(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIAgentReviewController.streamJSONArray((HttpServletResponse)resp, (Flux)this.agentReviewService.streamResults(projectKey, agentReviewId, runId));
    }

    @AuditedCall(value={"msgType", "agentreview-result-get", "projectKey", "${projectKey}", "resultId", "${resultId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/results/{resultId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewResult getResult(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String resultId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.getResult(projectKey, resultId);
    }

    @AuditedCall(value={"msgType", "agentreview-human-review-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/human-reviews"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewHumanReview> listHumanReviews(HttpServletRequest req, @PathVariable String projectKey, @RequestParam String resultId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.listHumanReviews(projectKey, resultId);
    }

    @AuditedCall(value={"msgType", "agentreview-human-review-get", "projectKey", "${projectKey}", "humanReviewId", "${humanReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/human-reviews/{humanReviewId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewHumanReview getHumanReview(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String humanReviewId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.getHumanReview(projectKey, humanReviewId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/human-reviews"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewHumanReview createHumanReview(HttpServletRequest req, @PathVariable String projectKey, @RequestBody AgentReviewHumanReview humanReview) throws DKUSecurityException, SQLException {
        AuthCtx user;
        if (!Objects.equals(projectKey, humanReview.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, projectKey);
        }
        this.auditTrailService.generic("agentreview-human-review-create").with("projectKey", humanReview.projectKey).with("resultId", humanReview.resultId).emit();
        return this.agentReviewService.createHumanReview(user, humanReview, true);
    }

    @AuditedCall(value={"msgType", "agentreview-human-review-save", "projectKey", "${projectKey}", "humanReviewId", "${humanReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/human-reviews/{humanReviewId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public AgentReviewHumanReview updateHumanReview(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String humanReviewId, @RequestBody AgentReviewHumanReview humanReview) throws SQLException, DKUSecurityException {
        AuthCtx authCtx;
        if (!Objects.equals(projectKey, humanReview.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        if (!Objects.equals(humanReviewId, humanReview.id)) {
            throw new IllegalArgumentException("Human review id in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.updateHumanReview(authCtx, humanReview, true);
    }

    @AuditedCall(value={"msgType", "agentreview-human-review-delete", "projectKey", "${projectKey}", "humanReviewId", "${humanReviewId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/human-reviews/{humanReviewId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteHumanReview(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String humanReviewId) throws SQLException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteHumanReview(authCtx, projectKey, humanReviewId);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/trait-overrides"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewTraitOverride> listTraitOverrides(HttpServletRequest req, @PathVariable String projectKey, @RequestParam String resultId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.listTraitOverrides(projectKey, resultId);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-get", "projectKey", "${projectKey}", "traitOverrideId", "${traitOverrideId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/trait-overrides/{traitOverrideId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewTraitOverride getTraitOverride(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String traitOverrideId) throws DKUSecurityException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.agentReviewService.getTraitOverride(projectKey, traitOverrideId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/trait-overrides"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewTraitOverride createTraitOverride(HttpServletRequest req, @PathVariable String projectKey, @RequestBody AgentReviewTraitOverride traitOverride) throws DKUSecurityException, SQLException {
        AuthCtx user;
        if (!Objects.equals(projectKey, traitOverride.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, projectKey);
        }
        this.auditTrailService.generic("agentreview-trait-override-create").with("projectKey", traitOverride.projectKey).with("resultId", traitOverride.resultId).with("traitId", traitOverride.traitId).emit();
        return this.agentReviewService.createTraitOverride(user, traitOverride, true);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-save", "projectKey", "${projectKey}", "traitOverrideId", "${traitOverrideId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/trait-overrides/{traitOverrideId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public AgentReviewTraitOverride updateTraitOverride(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String traitOverrideId, @RequestBody AgentReviewTraitOverride traitOverride) throws SQLException, DKUSecurityException {
        AuthCtx authCtx;
        if (!Objects.equals(projectKey, traitOverride.projectKey)) {
            throw new IllegalArgumentException("Project key in URL and in body must be the same");
        }
        if (!Objects.equals(traitOverrideId, traitOverride.id)) {
            throw new IllegalArgumentException("Trait override id in URL and in body must be the same");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.updateTraitOverride(authCtx, traitOverride, true);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-delete", "projectKey", "${projectKey}", "traitOverrideId", "${traitOverrideId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agent-reviews/trait-overrides/{traitOverrideId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTraitOverride(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String traitOverrideId) throws SQLException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteTraitOverride(authCtx, projectKey, traitOverrideId);
    }
}

