/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.documenttemplating.DocumentTemplatingInput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingOutput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIDocumentTemplatingController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DocumentTemplatingService documentTemplatingService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.documenttemplating.api");

    @AuditedCall(value={"msgType", "document-templating-render", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-templating/actions/render-template"}, method={RequestMethod.POST})
    @ResponseBody
    public DocumentTemplatingOutput renderTemplate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody DocumentTemplatingInput renderRequest) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        DocumentTemplatingOutput output = null;
        try {
            output = this.documentTemplatingService.render(authCtx, projectKey, renderRequest);
            output.ok = true;
        }
        catch (Exception e) {
            logger.error((Object)"Error during document templating render request", (Throwable)e);
            output = new DocumentTemplatingOutput();
            output.ok = false;
            output.error = new SerializedError((Throwable)e, false);
        }
        return output;
    }
}

