/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.qaonly;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.internal.InternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/admin/qa-only-routes"})
public class QAOnlyRoutesController {
    @Autowired
    ReadWriteJobsInternalDB readWriteJobsInternalDB;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    MetaAuthService metaAuthService;
    @Autowired
    RecipesDAO recipesDAO;
    @Autowired
    DatasetsDAO datasetsDAO;
    @Autowired
    InternalDataCatalogService internalDataCatalogService;
    @Autowired
    ExternalDataCatalogService externalDataCatalogService;

    private void checkQAContext(HttpServletRequest req) throws NotFoundException, DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        boolean qaSpecificRoutesEnabled = DKUApp.getParams().getBoolParam("dku.qaSpecificRoutesEnabled", false);
        if (!qaSpecificRoutesEnabled) {
            throw new NotFoundException("Unavailable route");
        }
    }

    @AuditedCall(value={"msgType", "fake-dataset-build"})
    @RequestMapping(value={"/fake-dataset-build"}, method={RequestMethod.POST})
    @ResponseBody
    public void fakeDatasetBuild(HttpServletRequest req, @RequestParam AnyLoc loc, @RequestParam long timestamp, @RequestParam(required=false) ReportItem.Outcome outcome) throws NotFoundException, DKUSecurityException {
        this.checkQAContext(req);
        DateTime dateTime = new DateTime(timestamp);
        JobContext jobContext = new JobContext();
        jobContext.projectKey = loc.getProjectKey();
        jobContext.jobId = "Build_" + loc.getId() + "__NP__" + String.valueOf(dateTime);
        jobContext.activity = "compute_" + loc.getId() + "_NP";
        ReportTargetItem.DatasetPartitionItem target = new ReportTargetItem.DatasetPartitionItem(loc.getProjectKey(), loc.getId(), "NA");
        ReportItem reportItem = new ReportItem.BuiltDataset((ReportTargetItem)target).withStart(dateTime.minusMinutes(1).getMillis()).withEnd(dateTime.getMillis()).withOutcome(outcome == null ? ReportItem.Outcome.SUCCESS : outcome);
        this.readWriteJobsInternalDB.tryRegisterFlowObjectEvent(loc, "NP", jobContext, null, null, reportItem);
    }

    @AuditedCall(value={"msgType", "fake-taggable-object-creation"})
    @RequestMapping(value={"/fake-taggable-object-creation"}, method={RequestMethod.POST})
    @ResponseBody
    public void fakeTaggableObjectCreation(HttpServletRequest req, @RequestParam TaggableObjectsService.TaggableObjectRef ref, @RequestParam long timestamp) throws Exception {
        this.checkQAContext(req);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            switch (ref.type) {
                case DATASET: {
                    SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(ref.getLoc());
                    dataset.creationTag = new VersionTag(authCtx.getIdentifier(), timestamp, 0L);
                    this.datasetsDAO.save(dataset);
                    break;
                }
                case RECIPE: {
                    SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                    recipe.creationTag = new VersionTag(authCtx.getIdentifier(), timestamp, 0L);
                    this.recipesDAO.save(ref.projectKey, ref.id, recipe, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported taggable type");
                }
            }
            t.commit("fake version tag for " + String.valueOf(ref));
        }
    }

    @AuditedCall(value={"msgType", "shift-all-dq-timestamps"})
    @RequestMapping(value={"/shift-all-dq-timestamps"}, method={RequestMethod.POST})
    @ResponseBody
    public void shiftAllDqTimestamps(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String objectId, @RequestParam long by) throws Exception {
        this.checkQAContext(req);
        this.readWriteJobsInternalDB.shiftAllDQTimestamps(projectKey, objectId, by);
    }

    @AuditedCall(value={"msgType", "shift-all-metrics-timestamps"})
    @RequestMapping(value={"/shift-all-metrics-timestamps"}, method={RequestMethod.POST})
    @ResponseBody
    public void shiftAllMetricsTimestamps(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String objectId, @RequestParam long by) throws Exception {
        this.checkQAContext(req);
        this.readWriteJobsInternalDB.shiftAllMetricsTimestamps(projectKey, objectId, by);
    }

    @AuditedCall(value={"msgType", "get-lucene-doc-by-id"})
    @RequestMapping(value={"/catalog/search/lucene"}, method={RequestMethod.GET})
    @ResponseBody
    public void getLuceneDocById(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam String type) throws Exception {
        this.checkQAContext(req);
        try {
            IndexableType indexableType = IndexableType.forName((String)type);
            DKUControllerBase.writeJSONString((HttpServletResponse)resp, (String)(switch (indexableType) {
                case IndexableType.DATASET, IndexableType.RECIPE, IndexableType.NOTEBOOK, IndexableType.INSIGHT, IndexableType.DASHBOARD, IndexableType.WEB_APP, IndexableType.REPORT, IndexableType.ANALYSIS, IndexableType.SAVED_MODEL, IndexableType.MODEL_EVALUATION_STORE, IndexableType.MANAGED_FOLDER, IndexableType.SCENARIO, IndexableType.ARTICLE, IndexableType.STATISTICS_WORKSHEET, IndexableType.MODEL_COMPARISON, IndexableType.FLOW_ZONE, IndexableType.LABELING_TASK, IndexableType.PROJECT, IndexableType.DATA_COLLECTION, IndexableType.KNOWLEDGE_BANK, IndexableType.PROMPT_STUDIO, IndexableType.AGENT_REVIEW, IndexableType.DISCUSSION -> this.internalDataCatalogService.getLuceneDocByIdMainIndex(id, indexableType);
                case IndexableType.TABLE -> this.externalDataCatalogService.getLuceneDocById(id);
                case IndexableType.COLUMN, IndexableType.MEANING -> this.internalDataCatalogService.getLuceneDocByIdColumnIndex(id, indexableType);
                case IndexableType.WORKSPACE, IndexableType.FEATURE_GROUP, IndexableType.FEATURE -> throw new IllegalArgumentException("Type " + type + " is not supported");
                default -> throw new IllegalArgumentException("Unknown type " + type);
            }).serializeHits());
        }
        catch (IllegalArgumentException e) {
            DKUControllerBase.sendErrorExplicit((int)400, (String)"BadRequest", (String)e.getMessage(), (HttpServletResponse)resp);
        }
        catch (IndexNotBuiltException e) {
            DKUControllerBase.sendErrorExplicit((int)503, (String)"NotReady", (String)"Data catalog is not ready yet (indexing)", (HttpServletResponse)resp);
        }
        catch (IndexingDisabledException e) {
            DKUControllerBase.sendErrorExplicit((int)503, (String)"Disabled", (String)"Indexing is disabled", (HttpServletResponse)resp);
        }
    }
}

