/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.external;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneMigrationHelper;
import com.dataiku.dip.server.services.catalog.LuceneQueryWrapper;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.server.services.catalog.external.ExternalCatalogIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.QueryParser;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectorManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollectorManager;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ExternalDataCatalogService
extends AbstractSearchService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    @Qualifier(value="externalMappingsAnalyzer")
    private LuceneMappingsAnalyzer externalLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="externalIndexManager")
    private LuceneIndexManager externalIndexManager;
    private ExternalCatalogIndexingQueueHandler queueHandler = new ExternalCatalogIndexingQueueHandler();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.external.service");
    private static final Gson gson = new Gson();
    public static final String TYPE = IndexableType.TABLE.index();

    @Override
    public AbstractIndexingQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    public InfoMessage.InfoMessages indexConnections(Collection<String> connectionNames, Map<String, InfoMessage.InfoMessages> messagesPerConnection) throws Exception {
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        this.queueHandler.indexConnections(connectionNames, messagesPerConnection);
        for (InfoMessage.InfoMessages messages : messagesPerConnection.values()) {
            result.mergeFrom(messages);
        }
        return result;
    }

    @Override
    public void subscribeEvents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper searchExternal(String queryString, Map<String, List<String>> facets, AuthCtx user, boolean retryEscaped, @Nullable String explainDocId) throws Exception {
        Query stringQuery;
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        LuceneQueryWrapper luceneQueryWrapper = new LuceneQueryWrapper();
        HashMap<String, Float> boosts = ExternalDataCatalogService.getSearchableFields();
        try {
            stringQuery = this.buildStringQuery(queryString, boosts, this.externalLuceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(TYPE), this.externalLuceneMappingsAnalyzer.getMappingForType(TYPE));
        }
        catch (ParseException e) {
            if (retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
                queryString = QueryParser.escape((String)queryString);
                return this.searchExternal(queryString, facets, user, false, explainDocId);
            }
            throw e;
        }
        BooleanQuery.Builder boolQueryBuilder = this.buildBoolQueryBuilder(stringQuery, user);
        luceneQueryWrapper.setQuery((Query)boolQueryBuilder.build());
        this.prepareSearch(facets, this.externalLuceneMappingsAnalyzer.getFacetsConfig(), IndexableType.forName((String)TYPE), this.externalLuceneMappingsAnalyzer.getBooleanFieldSetForType(TYPE), luceneQueryWrapper);
        IndexSearcher indexSearcher = this.externalIndexManager.acquireIndexSearcher();
        try {
            Query topDocsCollectorQuery = luceneQueryWrapper.getTopDocsCollectorQuery();
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"catalog.searchExternal.request");){
                TopDocs topDocs = (TopDocs)indexSearcher.search(topDocsCollectorQuery, (CollectorManager)new TopScoreDocCollectorManager(IInternalDataCatalogService.MAX_RESULTS, LuceneResponseWrapper.MAX_TOTAL_HITS));
                LuceneSecureIndexReader secureIndexReader = this.externalIndexManager.getSecureIndexReader(indexSearcher);
                this.addHitsInResponse(secureIndexReader, IndexableType.forName((String)TYPE), topDocs, result, this.externalIndexManager, ExternalDataCatalogService.getFieldsToHighlight(), this.externalLuceneMappingsAnalyzer.getTermVectorMappingForType(TYPE), stringQuery, this.externalLuceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(TYPE));
                this.searchFacets(indexSearcher, secureIndexReader, luceneQueryWrapper, result);
            }
            LuceneMigrationHelper.logLuceneExplanation(indexSearcher, topDocsCollectorQuery, explainDocId, IndexableType.TABLE.index());
        }
        finally {
            this.externalIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        if (result.totalHits.value == 0L && retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
            queryString = QueryParser.escape((String)queryString);
            return this.searchExternal(queryString, facets, user, false, explainDocId);
        }
        this.transformHits(result, user);
        result.serializeJsonPayloads(this.externalLuceneMappingsAnalyzer.getJsons(TYPE));
        return result;
    }

    private void transformHits(LuceneResponseWrapper result, AuthCtx user) throws DKUSecurityException, IOException {
        Set<String> allowedProjects = this.getAllowedProjects(user);
        for (LuceneResponseWrapper.Hit hit : result.hits) {
            List relatedProjects;
            Map source = hit._source;
            boolean relatedItemsChanged = false;
            String relatedItemsString = (String)source.get("$json_rawRelatedItems");
            Map relatedItems = (Map)gson.fromJson(relatedItemsString, Map.class);
            if (relatedItems == null || (relatedProjects = (List)relatedItems.get("projects")) == null) continue;
            ListIterator it = relatedProjects.listIterator();
            boolean removedSomething = false;
            while (it.hasNext()) {
                Map relatedProjectMap = (Map)it.next();
                String projectKey = (String)relatedProjectMap.get("key");
                if (projectKey != null && allowedProjects.contains(projectKey)) continue;
                relatedItemsChanged = true;
                removedSomething = true;
                it.remove();
            }
            if (!removedSomething) continue;
            relatedItems.put("projects", relatedProjects);
            source.put("$json_rawRelatedItems", gson.toJson((Object)relatedItems));
        }
    }

    private Set<String> getAllowedProjects(AuthCtx user) throws DKUSecurityException, IOException {
        HashSet<String> allowedProjects = new HashSet<String>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String projectKey : this.projectsService.listKeys()) {
                if (!this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                allowedProjects.add(projectKey);
            }
        }
        return allowedProjects;
    }

    @Override
    public Query accessFilter(AuthCtx user) throws DKUSecurityException {
        BooleanQuery.Builder accessibleTablesQuery = new BooleanQuery.Builder();
        accessibleTablesQuery.add((Query)new TermQuery(new Term("security.accessPolicy", DSSConnection.ConnectionUsableBy.ALL.toString())), BooleanClause.Occur.SHOULD);
        accessibleTablesQuery.add((Query)new TermQuery(new Term("security.owner", user.getIdentifier())), BooleanClause.Occur.SHOULD);
        user.getGroups().forEach(g -> accessibleTablesQuery.add((Query)new TermQuery(new Term("security.accessGroups", g)), BooleanClause.Occur.SHOULD));
        if (((DSSAuthCtx)user).getPermissions().mayViewIndexedHiveConnections()) {
            accessibleTablesQuery.add((Query)new TermQuery(new Term("security.accessPolicy", "INDEXED_HIVE")), BooleanClause.Occur.SHOULD);
        }
        return new BooleanQuery.Builder().add((Query)accessibleTablesQuery.build(), BooleanClause.Occur.MUST).build();
    }

    public static HashMap<String, Float> getSearchableFields() {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name", Float.valueOf(5.0f));
        boosts.put("name.lower", Float.valueOf(5.0f));
        boosts.put("catalog", Float.valueOf(3.0f));
        boosts.put("schema", Float.valueOf(3.0f));
        boosts.put("connection", Float.valueOf(3.0f));
        boosts.put("remarks", Float.valueOf(3.0f));
        boosts.put("description", Float.valueOf(3.0f));
        boosts.put("tag", Float.valueOf(3.0f));
        boosts.put("tag.plaintext", Float.valueOf(3.0f));
        boosts.put("remarks.lower", Float.valueOf(3.0f));
        boosts.put("columns.name", Float.valueOf(3.0f));
        boosts.put("columns.remarks", Float.valueOf(3.0f));
        boosts.put("column", Float.valueOf(3.0f));
        boosts.put("partitionColumns.name", Float.valueOf(3.0f));
        boosts.put("foreignKeys.fkTableKey.name", Float.valueOf(3.0f));
        boosts.put("foreignKeys.fkTableKey.catalog", Float.valueOf(3.0f));
        boosts.put("foreignKeys.fkTableKey.schema", Float.valueOf(3.0f));
        boosts.put("foreignKeys.pkTableKey.name", Float.valueOf(3.0f));
        boosts.put("foreignKeys.pkTableKey.catalog", Float.valueOf(3.0f));
        boosts.put("foreignKeys.pkTableKey.schema", Float.valueOf(3.0f));
        boosts.put("foreignKeys.pkColumnName", Float.valueOf(3.0f));
        boosts.put("foreignKeys.fkColumnName", Float.valueOf(3.0f));
        boosts.put("foreignKeys.fkName", Float.valueOf(3.0f));
        boosts.put("indexes.name", Float.valueOf(3.0f));
        boosts.put("indexes.columnName", Float.valueOf(2.0f));
        boosts.put("relatedItems.projects.name", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.key", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.datasets.name", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.datasets.description", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.datasets.contributors.login", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.datasets.contributors.displayName", Float.valueOf(3.0f));
        boosts.put("relatedItems.projects.datasets.contributors.displayemail", Float.valueOf(3.0f));
        boosts.put("users.login", Float.valueOf(1.0f));
        boosts.put("users.displayName", Float.valueOf(1.0f));
        boosts.put("users.email", Float.valueOf(1.0f));
        return boosts;
    }

    public static Set<String> getFieldsToHighlight() {
        return Set.of("column", "description", "indexes.name", "name.raw", "name", "relatedItems.projects.datasets.description", "relatedItems.projects.datasets.name", "relatedItems.projects.key", "relatedItems.projects.name", "remarks", "tag", "users.displayName", "users.email", "users.login");
    }

    public LuceneResponseWrapper getLuceneDocById(String docId) throws IOException, LuceneIndexException {
        return this.getLuceneDocById(docId, IndexableType.TABLE, this.externalIndexManager);
    }

    public LuceneResponseWrapper getExternalTable(String connection, String catalog, String schema, String table) throws IOException, LuceneIndexException {
        return this.getLuceneDocById(new DatabaseObjectKey(connection, catalog, schema, table).toKey());
    }
}

