/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.shims;

import com.dataiku.dip.hive.HiveSerdeShims;
import com.dataiku.dip.hive.shims.Hive3DSSDateObjectInspector;
import com.dataiku.dip.hive.shims.Hive3DSSTimestampObjectInspector;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class Hive3SerdeShims
implements HiveSerdeShims {
    private static final DateTimeFormatter ISO_DATE_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter DATE_ONLY_FORMATTER = ISODateTimeFormat.date().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter DATE_TIME_NO_TZ_FORMATTER = Hive3SerdeShims.dateTimeNoTzFormatter();

    public static DateTimeFormatter dateTimeNoTzFormatter() {
        return new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearMonthDay()).appendLiteral(" ").append(ISODateTimeFormat.hourMinuteSecondMillis()).toFormatter();
    }

    public DSSBaseInspector getTimestampInspector() {
        return new Hive3DSSTimestampObjectInspector();
    }

    public DSSBaseInspector getDateInspector() {
        return new Hive3DSSDateObjectInspector();
    }

    public String readTimestamp(PrimitiveObjectInspector oi, Object o) {
        if (o instanceof LongWritable) {
            LongWritable longWritable = (LongWritable)o;
            return DATE_TIME_NO_TZ_FORMATTER.print(longWritable.get() / 1000L);
        }
        Timestamp ts = ((TimestampObjectInspector)oi).getPrimitiveJavaObject(o);
        return ISO_DATE_FORMATTER.print(ts.toEpochMilli());
    }

    public Object asTimestamp(DSSBaseInspector oi, String val) {
        return Hive3DSSTimestampObjectInspector.asTimestampInternal(oi, val);
    }

    public Object asLocalTimestamp(DSSBaseInspector oi, String val) {
        return Hive3DSSTimestampObjectInspector.asLocalTimestampInternal(oi, val);
    }

    public String readDate(PrimitiveObjectInspector oi, Object o) {
        Date ts = ((DateObjectInspector)oi).getPrimitiveJavaObject(o);
        return DATE_ONLY_FORMATTER.print(ts.toEpochMilli());
    }

    public Object asDate(DSSBaseInspector oi, String val) {
        return Hive3DSSDateObjectInspector.asDateInternal(oi, val);
    }
}

