/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class NumberJDBCDataSink<T extends Number>
extends ConvertingJDBCDataSink {
    protected abstract void doSet(T var1) throws ErrorException, ConversionFailed;

    public NumberJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected final void handleConversionResult(Object object, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected final boolean conversionSuccessful() {
        return NonTrivialJDBCConversions.ConversionStatus.SUCCESS == this.getListener().getStatus();
    }

    protected boolean isSupportedSourceType(int n) {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 2000: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (!this.isSupportedSourceType(n)) {
            throw new IncorrectTypeException();
        }
        this.doSet(null);
    }

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setByte((byte)(bl ? 1 : 0));
    }
}

