/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.telemetry;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.core.interfaces.IDriver;
import com.databricks.client.hivecommon.telemetry.TelemetryUtil;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.nio.charset.Charset;

class DriverSystemConfiguration {
    public String driver_version;
    public String os_name;
    public String os_version;
    public String os_arch;
    public String runtime_name;
    public String runtime_version;
    public String runtime_vendor;
    public String client_app_name;
    public String locale_name;
    public String driver_name;
    public String char_set_encoding;
    public String process_name;

    public DriverSystemConfiguration(ILogger iLogger, String string) {
        IDriver iDriver = DSIDriverSingleton.getInstance();
        this.driver_version = "not_specified";
        this.os_name = "not_specified";
        this.os_version = "not_specified";
        this.os_arch = "not_specified";
        this.runtime_name = "not_specified";
        this.runtime_version = "not_specified";
        this.runtime_vendor = "not_specified";
        this.client_app_name = "not_specified";
        this.locale_name = "not_specified";
        this.driver_name = "not_specified";
        this.char_set_encoding = "not_specified";
        this.process_name = "not_specified";
        try {
            this.driver_version = iDriver.getProperty(5).getString();
            this.os_name = System.getProperty("os.name");
            this.os_version = System.getProperty("os.version");
            this.os_arch = System.getProperty("os.arch");
            this.runtime_name = System.getProperty("java.vm.name");
            this.runtime_version = System.getProperty("java.vm.version");
            this.runtime_vendor = System.getProperty("java.vm.specification.vendor");
            this.client_app_name = string;
            this.locale_name = iDriver.getLocale().toString();
            this.driver_name = "DatabricksJDBC";
            this.char_set_encoding = Charset.defaultCharset().displayName();
            this.process_name = TelemetryUtil.getProcessName(iLogger);
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }
}

