/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.core.jackson;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.util.Integers;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonParser;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonToken;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.DeserializationContext;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonMappingException;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;

public final class Log4jStackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public Log4jStackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = null;
            String methodName = null;
            String fileName = null;
            int lineNumber = -1;
            block15: while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName;
                switch (propName = jp.getCurrentName()) {
                    case "class": {
                        className = jp.getText();
                        continue block15;
                    }
                    case "file": {
                        fileName = jp.getText();
                        continue block15;
                    }
                    case "line": {
                        if (t.isNumeric()) {
                            lineNumber = jp.getIntValue();
                            continue block15;
                        }
                        try {
                            lineNumber = Integers.parseInt(jp.getText());
                            continue block15;
                        }
                        catch (NumberFormatException e) {
                            throw JsonMappingException.from(jp, "Non-numeric token (" + (Object)((Object)t) + ") for property 'line'", (Throwable)e);
                        }
                    }
                    case "method": {
                        methodName = jp.getText();
                        continue block15;
                    }
                }
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw JsonMappingException.from(jp, String.format("Cannot deserialize instance of %s out of %s token", new Object[]{ClassUtil.nameOf(this._valueClass), t}));
    }
}

